/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyControl;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;

public class AMQPFederationLocalPolicyControlType
extends AbstractControl
implements AMQPFederationLocalPolicyControl {
    private final AMQPFederationLocalPolicyManager policyManager;

    public AMQPFederationLocalPolicyControlType(AMQPFederationLocalPolicyManager policyManager) throws NotCompliantMBeanException {
        super(AMQPFederationLocalPolicyControl.class, policyManager.getFederation().getServer().getStorageManager());
        this.policyManager = policyManager;
    }

    @Override
    public String getType() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getType((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.policyManager);
        }
        this.clearIO();
        try {
            String string = this.policyManager.getPolicyName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.policyManager);
        }
        this.clearIO();
        try {
            long l = this.policyManager.getMetrics().getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPFederationLocalPolicyControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPFederationLocalPolicyControl.class);
    }
}

