/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.CheckedInputStream;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerRestoreTest
extends ZKTestCase {
    private static final String BASE_PATH = "/restoreFromSnapshotTest";
    private static final int NODE_COUNT = 10;
    private static final String HOST_PORT = "127.0.0.1:" + PortAssignment.unique();
    @TempDir
    static File dataDir;
    @TempDir
    static File logDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreFromSnapshot() throws Exception {
        ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)true);
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, logDir, 3000);
        int port = Integer.parseInt(HOST_PORT.split(":")[1]);
        ServerCnxnFactory serverCnxnFactory = ServerCnxnFactory.createFactory((int)port, (int)-1);
        ZooKeeper zk1 = null;
        ZooKeeper zk2 = null;
        ZooKeeper zk3 = null;
        try {
            serverCnxnFactory.startup(zks);
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOST_PORT, ClientBase.CONNECTION_TIMEOUT));
            zk1 = ClientBase.createZKClient(HOST_PORT);
            for (int i = 0; i < 10; ++i) {
                String path = "/restoreFromSnapshotTest-" + i;
                zk1.create(path, String.valueOf(i).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            File snapshotFile = zks.takeSnapshot(false, false, true);
            long lastZxidFromSnapshot = Util.getZxidFromName((String)snapshotFile.getName(), (String)"snapshot");
            zk2 = ClientBase.createZKClient(HOST_PORT);
            for (int i = 10; i < 20; ++i) {
                String path = "/restoreFromSnapshotTest-" + i;
                zk2.create(path, String.valueOf(i).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            try (CheckedInputStream is = SnapStream.getInputStream((File)snapshotFile);){
                long lastZxidFromRestore = zks.restoreFromSnapshot((InputStream)is);
                Assertions.assertEquals((long)lastZxidFromSnapshot, (long)lastZxidFromRestore);
                zk3 = ClientBase.createZKClient(HOST_PORT);
                for (int i = 0; i < 10; ++i) {
                    String path = "/restoreFromSnapshotTest-" + i;
                    String expectedData = String.valueOf(i);
                    Assertions.assertArrayEquals((byte[])expectedData.getBytes(), (byte[])zk3.getData(path, null, null));
                }
                Assertions.assertEquals((int)13, (int)zk3.getAllChildrenNumber("/"));
                SessionTracker sessionTracker = zks.getSessionTracker();
                Set globalSessions = sessionTracker.globalSessions();
                Assertions.assertEquals((int)2, (int)globalSessions.size());
                Assertions.assertTrue((boolean)globalSessions.contains(zk1.getSessionId()));
                Assertions.assertFalse((boolean)globalSessions.contains(zk2.getSessionId()));
                Assertions.assertTrue((boolean)globalSessions.contains(zk3.getSessionId()));
                Assertions.assertEquals((Object)ZooKeeperServer.State.RUNNING, (Object)zks.state);
                zk3.create("/restoreFromSnapshotTest_after", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                Assertions.assertEquals((int)14, (int)zk3.getAllChildrenNumber("/"));
            }
        }
        finally {
            System.clearProperty("zookeeper.serializeLastProcessedZxid.enabled");
            if (zk1 != null) {
                zk1.close();
            }
            if (zk2 != null) {
                zk2.close();
            }
            if (zk3 != null) {
                zk3.close();
            }
            zks.shutdown();
            serverCnxnFactory.shutdown();
        }
    }

    @Test
    public void testRestoreFromSnapshot_nulInputStream() throws Exception {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, logDir, 3000);
        Assertions.assertThrows(IllegalArgumentException.class, () -> zks.restoreFromSnapshot(null));
    }
}

