/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.distributed.impl;

import com.google.common.base.Preconditions;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.cassandra.distributed.UpgradeableCluster;
import org.apache.cassandra.distributed.api.ICluster;
import org.apache.cassandra.distributed.api.ICoordinator;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.distributed.api.IInstanceConfig;
import org.apache.cassandra.distributed.api.IMessage;
import org.apache.cassandra.distributed.api.IMessageFilters;
import org.apache.cassandra.distributed.api.IMessageSink;
import org.apache.cassandra.distributed.api.TokenSupplier;
import org.apache.cassandra.distributed.impl.AbstractCluster;
import org.apache.cassandra.distributed.shared.ClusterUtils;
import org.apache.cassandra.distributed.shared.NetworkTopology;
import org.apache.cassandra.distributed.shared.Versions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.IClusterExtension;
import org.apache.cassandra.testing.Partitioner;
import org.apache.cassandra.testing.TestTokenSupplier;
import org.jetbrains.annotations.NotNull;

public class CassandraCluster<I extends IInstance>
implements IClusterExtension<I> {
    private final AbstractCluster<I> delegate;
    private static final Predicate<String> EXTRA = className -> className.equals("org.apache.cassandra.utils.concurrent.Ref$OnLeak") || className.startsWith("org.apache.cassandra.metrics.RestorableMeter") || className.equals("org.apache.logging.slf4j.EventDataConverter") || className.equals("org.apache.cassandra.cql3.functions.masking.ColumnMask") || className.startsWith("org.apache.cassandra.analytics.") && className.contains("BBHelper");

    public CassandraCluster(String versionString, ClusterBuilderConfiguration configuration) throws IOException {
        this.delegate = this.initializeCluster(versionString, configuration);
    }

    public AbstractCluster<I> initializeCluster(String versionString, ClusterBuilderConfiguration configuration) throws IOException {
        UpgradeableCluster cluster;
        Consumer<IInstanceConfig> instanceConfigUpdater;
        TokenSupplier tokenSupplier;
        Versions versions = Versions.find();
        Versions.Version requestedVersion = versions.getLatest(new Semver(versionString, Semver.SemverType.LOOSE));
        int nodesPerDc = configuration.nodesPerDc;
        int dcCount = configuration.dcCount;
        int newNodesPerDc = configuration.newNodesPerDc;
        Preconditions.checkArgument((newNodesPerDc >= 0 ? 1 : 0) != 0, (Object)"newNodesPerDc cannot be a negative number");
        int originalNodeCount = nodesPerDc * dcCount;
        int finalNodeCount = dcCount * (nodesPerDc + newNodesPerDc);
        UpgradeableCluster.Builder clusterBuilder = UpgradeableCluster.build((int)originalNodeCount);
        ((UpgradeableCluster.Builder)((UpgradeableCluster.Builder)((UpgradeableCluster.Builder)((UpgradeableCluster.Builder)((UpgradeableCluster.Builder)clusterBuilder.withVersion(requestedVersion)).withDynamicPortAllocation(configuration.dynamicPortAllocation)).withSharedClasses(EXTRA.or(clusterBuilder.getSharedClasses()))).withDCs(dcCount)).withTokenCount(configuration.tokenCount)).withDataDirCount(configuration.numDataDirsPerInstance);
        if (configuration.tokenCount > 1) {
            clusterBuilder.withVNodes();
        }
        if (configuration.partitioner != null) {
            tokenSupplier = TestTokenSupplier.evenlyDistributedTokens(Partitioner.fromClassName(configuration.partitioner), nodesPerDc, newNodesPerDc, dcCount, configuration.tokenCount);
            instanceConfigUpdater = instanceConfig -> {
                instanceConfig.set("partitioner", (Object)configuration.partitioner);
                configuration.features.forEach(arg_0 -> ((IInstanceConfig)instanceConfig).with(arg_0));
            };
        } else {
            tokenSupplier = TestTokenSupplier.evenlyDistributedTokens(nodesPerDc, newNodesPerDc, dcCount, configuration.tokenCount);
            instanceConfigUpdater = config -> configuration.features.forEach(arg_0 -> ((IInstanceConfig)config).with(arg_0));
        }
        if (configuration.additionalInstanceConfig != null) {
            instanceConfigUpdater = instanceConfigUpdater.andThen(config -> configuration.additionalInstanceConfig.forEach((arg_0, arg_1) -> ((IInstanceConfig)config).set(arg_0, arg_1)));
        }
        ((UpgradeableCluster.Builder)clusterBuilder.withTokenSupplier(tokenSupplier)).withConfig(instanceConfigUpdater);
        if (dcCount > 1) {
            if (configuration.dcAndRackSupplier != null) {
                clusterBuilder.withNodeIdTopology(NetworkTopology.networkTopology((int)finalNodeCount, configuration.dcAndRackSupplier));
            } else {
                clusterBuilder.withNodeIdTopology(NetworkTopology.networkTopology((int)finalNodeCount, nodeId -> nodeId % 2 != 0 ? NetworkTopology.dcAndRack((String)"datacenter1", (String)"rack1") : NetworkTopology.dcAndRack((String)"datacenter2", (String)"rack2")));
            }
        }
        if (configuration.instanceInitializer != null) {
            clusterBuilder.withInstanceInitializer(configuration.instanceInitializer);
        }
        if ((cluster = (UpgradeableCluster)clusterBuilder.start()).size() > 1) {
            this.waitForHealthyRing((ICluster<?>)cluster);
            this.fixDistributedSchemas((AbstractCluster<I>)cluster);
        }
        return cluster;
    }

    @Override
    public void schemaChangeIgnoringStoppedInstances(String query) {
        this.delegate.schemaChangeIgnoringStoppedInstances(query);
    }

    @Override
    public I addInstance(String dc, String rack, Consumer<IInstanceConfig> fn) {
        return (I)ClusterUtils.addInstance(this.delegate, (String)dc, (String)rack, fn);
    }

    @Override
    public I getFirstRunningInstance() {
        return (I)this.delegate.getFirstRunningInstance();
    }

    @Override
    public IInstanceConfig newInstanceConfig() {
        return this.delegate.newInstanceConfig();
    }

    @Override
    public ICluster<I> delegate() {
        return this.delegate;
    }

    @Override
    public void awaitRingState(IInstance instance, IInstance expectedInRing, String state) {
        ClusterUtils.awaitRingState((IInstance)instance, (IInstance)expectedInRing, (String)state);
    }

    @Override
    public void awaitRingStatus(IInstance instance, IInstance expectedInRing, String status) {
        ClusterUtils.awaitRingStatus((IInstance)instance, (IInstance)expectedInRing, (String)status);
    }

    @Override
    public void awaitGossipStatus(IInstance instance, IInstance expectedInGossip, String targetStatus) {
        ClusterUtils.awaitGossipStatus((IInstance)instance, (IInstance)expectedInGossip, (String)targetStatus);
    }

    @Override
    public void stopUnchecked(IInstance instance) {
        ClusterUtils.stopUnchecked((IInstance)instance);
    }

    public void startup() {
        this.delegate.startup();
    }

    public I bootstrap(IInstanceConfig iInstanceConfig) {
        return (I)this.delegate.bootstrap(iInstanceConfig);
    }

    public I get(int i) {
        return (I)this.delegate.get(i);
    }

    public I get(InetSocketAddress inetSocketAddress) {
        return (I)this.delegate.get(inetSocketAddress);
    }

    public ICoordinator coordinator(int i) {
        return this.delegate.coordinator(i);
    }

    public void schemaChange(String s) {
        this.delegate.schemaChange(s);
    }

    public void schemaChange(String s, int i) {
        this.delegate.schemaChange(s, i);
    }

    public int size() {
        return this.delegate.size();
    }

    public Stream<I> stream() {
        return this.delegate.stream();
    }

    public Stream<I> stream(String s) {
        return this.delegate.stream(s);
    }

    public Stream<I> stream(String s, String s1) {
        return this.delegate.stream(s, s1);
    }

    @NotNull
    public Iterator<I> iterator() {
        return this.delegate.iterator();
    }

    public IMessageFilters filters() {
        return this.delegate.filters();
    }

    public void setMessageSink(IMessageSink messageSink) {
        this.delegate.setMessageSink(messageSink);
    }

    public void deliverMessage(InetSocketAddress to, IMessage msg) {
        this.delegate.deliverMessage(to, msg);
    }

    public void setUncaughtExceptionsFilter(BiPredicate<Integer, Throwable> ignoreThrowable) {
        this.delegate.setUncaughtExceptionsFilter(ignoreThrowable);
    }

    public void setUncaughtExceptionsFilter(Predicate<Throwable> ignoreThrowable) {
        this.delegate.setUncaughtExceptionsFilter(ignoreThrowable);
    }

    public void checkAndResetUncaughtExceptions() {
        this.delegate.checkAndResetUncaughtExceptions();
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    public void forEach(Consumer<? super I> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<I> spliterator() {
        return this.delegate.spliterator();
    }

    void fixDistributedSchemas(AbstractCluster<I> cluster) {
        for (String ks : Arrays.asList("system_auth", "system_traces")) {
            cluster.schemaChange("ALTER KEYSPACE " + ks + " WITH REPLICATION = {'class': 'SimpleStrategy', 'replication_factor': " + Math.min(cluster.size(), 3) + "}", true, cluster.getFirstRunningInstance());
        }
    }

    void waitForHealthyRing(ICluster<?> cluster) {
        for (IInstance inst : cluster) {
            ClusterUtils.awaitRingHealthy((IInstance)inst);
        }
    }
}

