/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Boolean
extends NativeType {
    public static final Boolean INSTANCE = new Boolean();

    public String name() {
        return "boolean";
    }

    @Override
    public AbstractType<?> dataType() {
        return BooleanType.instance;
    }

    @Override
    public int cardinality(int orElse) {
        return 2;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return RandomUtils.RANDOM.nextBoolean();
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setBool(position, ((java.lang.Boolean)value).booleanValue());
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.cboolean();
    }
}

