/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;

public final class InternalMessageToTextQueueEntryHandler
implements QueueEntryHandler {
    private final Bytes<?> textConversionTarget = Bytes.elasticByteBuffer();
    private final WireType wireType;

    public InternalMessageToTextQueueEntryHandler(WireType wireType) {
        this.wireType = ObjectUtils.requireNonNull(wireType);
    }

    private static boolean isBinaryFormat(byte dataFormatIndicator) {
        return dataFormatIndicator < 0;
    }

    @Override
    public void accept(WireIn wireIn, Consumer<String> messageHandler) {
        String text;
        Bytes serialisedMessage = wireIn.bytes();
        byte dataFormatIndicator = serialisedMessage.readByte(serialisedMessage.readPosition());
        if (InternalMessageToTextQueueEntryHandler.isBinaryFormat(dataFormatIndicator)) {
            this.textConversionTarget.clear();
            BinaryWire binaryWire = new BinaryWire(serialisedMessage);
            binaryWire.copyTo((WireOut)this.wireType.apply(this.textConversionTarget));
            text = this.textConversionTarget.toString();
        } else {
            text = serialisedMessage.toString();
        }
        messageHandler.accept(text);
    }

    @Override
    public void close() {
        this.textConversionTarget.releaseLast();
    }
}

