/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaChangeListener;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeEstimatesRecorder
implements SchemaChangeListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SizeEstimatesRecorder.class);
    public static final SizeEstimatesRecorder instance = new SizeEstimatesRecorder();

    private SizeEstimatesRecorder() {
        Schema.instance.registerListener(this);
    }

    @Override
    public void run() {
        TokenMetadata metadata = StorageService.instance.getTokenMetadata().cloneOnlyTokenMap();
        if (!metadata.isMember(FBUtilities.getBroadcastAddressAndPort())) {
            logger.debug("Node is not part of the ring; not recording size estimates");
            return;
        }
        logger.trace("Recording size estimates");
        for (Keyspace keyspace : Keyspace.nonLocalStrategy()) {
            Collection<Range<Token>> primaryRanges = StorageService.instance.getPrimaryRanges(keyspace.getName());
            Collection<Range<Token>> localPrimaryRanges = StorageService.instance.getLocalPrimaryRange();
            boolean rangesAreEqual = primaryRanges.equals(localPrimaryRanges);
            for (ColumnFamilyStore table : keyspace.getColumnFamilyStores()) {
                long start = Clock.Global.nanoTime();
                Map<Range<Token>, Pair<Long, Long>> estimates = SizeEstimatesRecorder.computeSizeEstimates(table, primaryRanges);
                SystemKeyspace.updateSizeEstimates(table.metadata.keyspace, table.metadata.name, estimates);
                SystemKeyspace.updateTableEstimates(table.metadata.keyspace, table.metadata.name, "primary", estimates);
                if (!rangesAreEqual) {
                    estimates = SizeEstimatesRecorder.computeSizeEstimates(table, localPrimaryRanges);
                }
                SystemKeyspace.updateTableEstimates(table.metadata.keyspace, table.metadata.name, "local_primary", estimates);
                long passed = Clock.Global.nanoTime() - start;
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Spent {} milliseconds on estimating {}.{} size", new Object[]{TimeUnit.NANOSECONDS.toMillis(passed), table.metadata.keyspace, table.metadata.name});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Range<Token>, Pair<Long, Long>> computeSizeEstimates(ColumnFamilyStore table, Collection<Range<Token>> ranges) {
        HashMap<Range<Token>, Pair<Long, Long>> estimates = new HashMap<Range<Token>, Pair<Long, Long>>(ranges.size());
        for (Range<Token> localRange : ranges) {
            for (Range<Token> unwrappedRange : localRange.unwrap()) {
                long meanPartitionSize;
                long partitionsCount;
                Refs<SSTableReader> refs = null;
                try {
                    while (refs == null) {
                        Iterable<SSTableReader> sstables = table.getTracker().getView().select(SSTableSet.CANONICAL);
                        SSTableIntervalTree tree = SSTableIntervalTree.buildSSTableIntervalTree(ImmutableList.copyOf(sstables));
                        Range<PartitionPosition> r = Range.makeRowRange(unwrappedRange);
                        List<SSTableReader> canonicalSSTables = View.sstablesInBounds((PartitionPosition)r.left, (PartitionPosition)r.right, tree);
                        refs = Refs.tryRef(canonicalSSTables);
                    }
                    partitionsCount = SizeEstimatesRecorder.estimatePartitionsCount(refs, unwrappedRange);
                    meanPartitionSize = SizeEstimatesRecorder.estimateMeanPartitionSize((Collection<SSTableReader>)refs);
                }
                finally {
                    if (refs != null) {
                        refs.release();
                    }
                }
                estimates.put(unwrappedRange, Pair.create(partitionsCount, meanPartitionSize));
            }
        }
        return estimates;
    }

    private static long estimatePartitionsCount(Collection<SSTableReader> sstables, Range<Token> range) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            count += sstable.estimatedKeysForRanges(Collections.singleton(range));
        }
        return count;
    }

    private static long estimateMeanPartitionSize(Collection<SSTableReader> sstables) {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            long n = sstable.getEstimatedPartitionSize().count();
            sum += sstable.getEstimatedPartitionSize().mean() * n;
            count += n;
        }
        return count > 0L ? sum / count : 0L;
    }

    @Override
    public void onDropTable(TableMetadata table, boolean dropData) {
        SystemKeyspace.clearEstimates(table.keyspace, table.name);
    }
}

