/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import ch.obermuhlner.math.big.BigDecimalMath;
import com.google.common.primitives.Ints;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.DecimalSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class DecimalType
extends NumberType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose(BigDecimal.ZERO);
    private static final int MIN_SCALE = 32;
    private static final int MIN_SIGNIFICANT_DIGITS = 32;
    private static final int MAX_SCALE = 1000;
    private static final MathContext MAX_PRECISION = new MathContext(10000);
    private static final int POSITIVE_DECIMAL_HEADER_MASK = 128;
    private static final int NEGATIVE_DECIMAL_HEADER_MASK = 0;
    private static final int DECIMAL_EXPONENT_LENGTH_HEADER_MASK = 64;
    private static final byte DECIMAL_LAST_BYTE = 0;
    private static final BigInteger HUNDRED = BigInteger.valueOf(100L);
    private static final ByteBuffer ZERO_BUFFER = instance.decompose(BigDecimal.ZERO);

    DecimalType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean allowsEmpty() {
        return true;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return DecimalType.compareComposed(left, accessorL, right, accessorR, this);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        int modulatedExponent;
        BigDecimal value = (BigDecimal)this.compose(data, accessor);
        if (value == null) {
            return null;
        }
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return ByteSource.oneByte(128);
        }
        long scale = (long)value.scale() - (long)value.precision() & 0xFFFFFFFFFFFFFFFEL;
        final boolean negative = value.signum() < 0;
        int exponent = Math.toIntExact(-scale >> 1);
        int n = modulatedExponent = negative ? -exponent : exponent;
        assert (scale <= Integer.MAX_VALUE);
        if (scale < Integer.MIN_VALUE) {
            int mv = Integer.MIN_VALUE;
            value = value.scaleByPowerOfTen(mv);
            scale -= (long)mv;
        }
        final BigDecimal mantissa = value.scaleByPowerOfTen(Ints.checkedCast(scale)).stripTrailingZeros();
        assert (mantissa.abs().compareTo(BigDecimal.ONE) < 0);
        return new ByteSource(){
            int exponentBytesLeft = 5;
            BigDecimal current = mantissa;

            @Override
            public int next() {
                if (this.exponentBytesLeft > 0) {
                    --this.exponentBytesLeft;
                    if (this.exponentBytesLeft == 4) {
                        this.exponentBytesLeft -= Integer.numberOfLeadingZeros(Math.abs(modulatedExponent)) / 8;
                        int explen = 64 + (modulatedExponent < 0 ? -this.exponentBytesLeft : this.exponentBytesLeft);
                        return explen + (negative ? 0 : 128);
                    }
                    return modulatedExponent >> this.exponentBytesLeft * 8 & 0xFF;
                }
                if (this.current == null) {
                    return -1;
                }
                if (this.current.compareTo(BigDecimal.ZERO) == 0) {
                    this.current = null;
                    return 0;
                }
                BigDecimal v = this.current.scaleByPowerOfTen(2);
                BigDecimal floor = v.setScale(0, RoundingMode.FLOOR);
                this.current = v.subtract(floor);
                return floor.byteValueExact() + 128;
            }
        };
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        int headerBits = comparableBytes.next();
        if (headerBits == 128) {
            return accessor.valueOf(ZERO_BUFFER);
        }
        boolean isNegative = headerBits < 128;
        headerBits -= isNegative ? 0 : 128;
        boolean isExponentNegative = (headerBits -= 64) < 0;
        headerBits = isExponentNegative ? -headerBits : headerBits;
        int exponent = isExponentNegative ? -1 : 0;
        for (int i = 0; i < headerBits; ++i) {
            exponent = exponent << 8 | comparableBytes.next();
        }
        exponent = isNegative ? -exponent : exponent;
        BigInteger mantissa = BigInteger.ZERO;
        int curr = comparableBytes.next();
        while (curr != 0) {
            int currModified = curr - 128;
            mantissa = mantissa.multiply(HUNDRED);
            mantissa = mantissa.add(BigInteger.valueOf(currModified));
            --exponent;
            curr = comparableBytes.next();
        }
        long base10NonBigDecimalFormatExp = 2L * (long)exponent;
        if (base10NonBigDecimalFormatExp > Integer.MAX_VALUE) {
            int exponentReduction = (int)(base10NonBigDecimalFormatExp - Integer.MAX_VALUE);
            mantissa = mantissa.multiply(BigInteger.TEN.pow(exponentReduction));
            base10NonBigDecimalFormatExp = Integer.MAX_VALUE;
        }
        assert (base10NonBigDecimalFormatExp >= Integer.MIN_VALUE && base10NonBigDecimalFormatExp <= Integer.MAX_VALUE);
        byte[] mantissaBytes = mantissa.toByteArray();
        V resultBuf = accessor.allocate(4 + mantissaBytes.length);
        accessor.putInt(resultBuf, 0, (int)(-base10NonBigDecimalFormatExp));
        accessor.copyByteArrayTo(mantissaBytes, 0, resultBuf, 4, mantissaBytes.length);
        return resultBuf;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString(Objects.toString(parsed)));
        }
        catch (NumberFormatException | MarshalException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a decimal value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }

    @Override
    public TypeSerializer<BigDecimal> getSerializer() {
        return DecimalSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    protected BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        double d = number.doubleValue();
        if (Double.isNaN(d)) {
            throw new NumberFormatException("A NaN cannot be converted into a decimal");
        }
        if (Double.isInfinite(d)) {
            throw new NumberFormatException("An infinite number cannot be converted into a decimal");
        }
        return BigDecimal.valueOf(d);
    }

    @Override
    public ByteBuffer add(Number left, Number right) {
        return this.decompose(this.toBigDecimal(left).add(this.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer substract(Number left, Number right) {
        return this.decompose(this.toBigDecimal(left).subtract(this.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer multiply(Number left, Number right) {
        return this.decompose(this.toBigDecimal(left).multiply(this.toBigDecimal(right), MAX_PRECISION));
    }

    @Override
    public ByteBuffer divide(Number left, Number right) {
        BigDecimal leftOperand = this.toBigDecimal(left);
        BigDecimal rightOperand = this.toBigDecimal(right);
        int quotientFirstDigitPos = leftOperand.precision() - leftOperand.scale() - (rightOperand.precision() - rightOperand.scale());
        int scale = 32 - quotientFirstDigitPos;
        scale = Math.max(scale, leftOperand.scale());
        scale = Math.max(scale, rightOperand.scale());
        scale = Math.max(scale, 32);
        scale = Math.min(scale, 1000);
        return this.decompose(leftOperand.divide(rightOperand, scale, RoundingMode.HALF_UP).stripTrailingZeros());
    }

    @Override
    public ByteBuffer mod(Number left, Number right) {
        return this.decompose(this.toBigDecimal(left).remainder(this.toBigDecimal(right)));
    }

    @Override
    public ByteBuffer negate(Number input) {
        return this.decompose(this.toBigDecimal(input).negate());
    }

    @Override
    public ByteBuffer abs(Number input) {
        return this.decompose(this.toBigDecimal(input).abs());
    }

    @Override
    public ByteBuffer exp(Number input) {
        return this.decompose(this.exp(this.toBigDecimal(input)));
    }

    protected BigDecimal exp(BigDecimal input) {
        int precision = input.precision();
        precision = Math.max(32, precision);
        precision = Math.min(MAX_PRECISION.getPrecision(), precision);
        return BigDecimalMath.exp(input, new MathContext(precision, RoundingMode.HALF_EVEN));
    }

    @Override
    public ByteBuffer log(Number input) {
        return this.decompose(this.log(this.toBigDecimal(input)));
    }

    protected BigDecimal log(BigDecimal input) {
        if (input.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ArithmeticException("Natural log of number zero or less");
        }
        int precision = input.precision();
        precision = Math.max(32, precision);
        precision = Math.min(MAX_PRECISION.getPrecision(), precision);
        return BigDecimalMath.log(input, new MathContext(precision, RoundingMode.HALF_EVEN));
    }

    @Override
    public ByteBuffer log10(Number input) {
        return this.decompose(this.log10(this.toBigDecimal(input)));
    }

    protected BigDecimal log10(BigDecimal input) {
        if (input.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ArithmeticException("Log10 of number zero or less");
        }
        int precision = input.precision();
        precision = Math.max(32, precision);
        precision = Math.min(MAX_PRECISION.getPrecision(), precision);
        return BigDecimalMath.log10(input, new MathContext(precision, RoundingMode.HALF_EVEN));
    }

    @Override
    public ByteBuffer round(Number input) {
        return instance.decompose(this.toBigDecimal(input).setScale(0, RoundingMode.HALF_UP));
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

