/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.v1.PerColumnIndexFiles;
import org.apache.cassandra.index.sai.disk.v1.segment.IndexSegmentSearcher;
import org.apache.cassandra.index.sai.disk.v1.segment.LiteralIndexSegmentTermsReader;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.metrics.MulticastQueryEventListeners;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralIndexSegmentSearcher
extends IndexSegmentSearcher {
    private static final Logger logger = LoggerFactory.getLogger(LiteralIndexSegmentSearcher.class);
    private final LiteralIndexSegmentTermsReader reader;
    private final QueryEventListener.TrieIndexEventListener perColumnEventListener;

    LiteralIndexSegmentSearcher(PrimaryKeyMap.Factory primaryKeyMapFactory, PerColumnIndexFiles perIndexFiles, SegmentMetadata segmentMetadata, StorageAttachedIndex index) throws IOException {
        super(primaryKeyMapFactory, perIndexFiles, segmentMetadata, index);
        long root = this.metadata.getIndexRoot(IndexComponent.TERMS_DATA);
        assert (root >= 0L);
        this.perColumnEventListener = (QueryEventListener.TrieIndexEventListener)((Object)index.columnQueryMetrics());
        Map<String, String> map = this.metadata.componentMetadatas.get((IndexComponent)IndexComponent.TERMS_DATA).attributes;
        String footerPointerString = map.get("footerPointer");
        long footerPointer = footerPointerString == null ? -1L : Long.parseLong(footerPointerString);
        this.reader = new LiteralIndexSegmentTermsReader(index.identifier(), this.indexFiles.termsData(), this.indexFiles.postingLists(), root, footerPointer);
    }

    @Override
    public long indexFileCacheSize() {
        return 0L;
    }

    @Override
    public KeyRangeIterator search(Expression expression, AbstractBounds<PartitionPosition> keyRange, QueryContext queryContext) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.index.identifier().logMessage("Searching on expression '{}'..."), (Object)expression);
        }
        if (!expression.getIndexOperator().isEquality()) {
            throw new IllegalArgumentException(this.index.identifier().logMessage("Unsupported expression: " + expression));
        }
        ByteComparable term = v -> this.index.termType().asComparableBytes(expression.lower().value.encoded, v);
        QueryEventListener.TrieIndexEventListener listener = MulticastQueryEventListeners.of(queryContext, this.perColumnEventListener);
        return this.toPrimaryKeyIterator(this.reader.exactMatch(term, listener, queryContext), queryContext);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("index", this.index).toString();
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

