/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.MetricsProviders;
import org.apache.cassandra.io.sstable.SimpleGaugeProvider;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public abstract class AbstractMetricsProviders<R extends SSTableReader>
implements MetricsProviders {
    protected final <T extends Number> GaugeProvider<T> newGaugeProvider(String name, Function<Iterable<R>, T> combiner) {
        return new SimpleGaugeProvider<T, SSTableReader>(this::map, name, combiner);
    }

    protected final <T extends Number> GaugeProvider<T> newGaugeProvider(String name, T neutralValue, Function<R, T> extractor, BiFunction<T, T, T> combiner) {
        return new SimpleGaugeProvider<Number, SSTableReader>(this::map, name, readers -> {
            Number total = neutralValue;
            for (SSTableReader reader : readers) {
                total = (Number)combiner.apply(total, (Number)extractor.apply(reader));
            }
            return total;
        });
    }

    protected abstract R map(SSTableReader var1);
}

