/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.consistent.LocalSession;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

public class LocalSessionInfo {
    public static final String SESSION_ID = "SESSION_ID";
    public static final String STATE = "STATE";
    public static final String STARTED = "STARTED";
    public static final String LAST_UPDATE = "LAST_UPDATE";
    public static final String COORDINATOR = "COORDINATOR";
    public static final String PARTICIPANTS = "PARTICIPANTS";
    public static final String PARTICIPANTS_WP = "PARTICIPANTS_WP";
    public static final String TABLES = "TABLES";

    private LocalSessionInfo() {
    }

    private static String tableString(TableId id) {
        TableMetadata meta = Schema.instance.getTableMetadata(id);
        return meta != null ? meta.keyspace + "." + meta.name : "<null>";
    }

    static Map<String, String> sessionToMap(LocalSession session) {
        HashMap<String, String> m4 = new HashMap<String, String>();
        m4.put(SESSION_ID, session.sessionID.toString());
        m4.put(STATE, session.getState().toString());
        m4.put(STARTED, Long.toString(session.getStartedAt()));
        m4.put(LAST_UPDATE, Long.toString(session.getLastUpdate()));
        m4.put(COORDINATOR, session.coordinator.toString());
        m4.put(PARTICIPANTS, Joiner.on(',').join(Iterables.transform(session.participants.stream().map(peer -> peer.getAddress()).collect(Collectors.toList()), InetAddress::getHostAddress)));
        m4.put(PARTICIPANTS_WP, Joiner.on(',').join(Iterables.transform(session.participants, InetAddressAndPort::getHostAddressAndPort)));
        m4.put(TABLES, Joiner.on(',').join(Iterables.transform(session.tableIds, LocalSessionInfo::tableString)));
        return m4;
    }
}

