/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.repair.state.SyncState;
import org.apache.cassandra.repair.state.ValidationState;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.TimeUUID;

public class ParticipateState
extends AbstractCompletable<TimeUUID> {
    public final InetAddressAndPort initiator;
    public final List<TableId> tableIds;
    public final Collection<Range<Token>> ranges;
    public final boolean incremental;
    public final long repairedAt;
    public final boolean global;
    public final PreviewKind previewKind;
    private volatile boolean accepted = false;
    public final Phase phase = new Phase();
    public final ConcurrentMap<RepairJobDesc, Job> jobs = new ConcurrentHashMap<RepairJobDesc, Job>();

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    public ParticipateState(Clock clock, InetAddressAndPort initiator, PrepareMessage msg) {
        super(clock, msg.parentRepairSession);
        this.initiator = initiator;
        this.tableIds = msg.tableIds;
        this.ranges = msg.ranges;
        this.incremental = msg.isIncremental;
        this.repairedAt = msg.repairedAt;
        this.global = msg.isGlobal;
        this.previewKind = msg.previewKind;
    }

    @Nullable
    public Job job(RepairJobDesc desc) {
        return (Job)this.jobs.get(desc);
    }

    public Job getOrCreateJob(RepairJobDesc desc) {
        return this.jobs.computeIfAbsent(desc, d -> new Job(this.clock, (RepairJobDesc)d));
    }

    @Nullable
    public ValidationState validation(RepairJobDesc desc) {
        Job job = this.job(desc);
        if (job == null) {
            return null;
        }
        return job.validation();
    }

    public RegisterStatus register(ValidationState state) {
        return this.getOrCreateJob(state.desc).register(state);
    }

    @Nullable
    public SyncState sync(RepairJobDesc desc, SyncState.Id id) {
        Job job = this.job(desc);
        if (job == null) {
            return null;
        }
        return job.sync(id);
    }

    public RegisterStatus register(SyncState state) {
        return this.getOrCreateJob(((SyncState.Id)state.id).desc).register(state);
    }

    public Collection<ValidationState> validations() {
        return this.jobs.values().stream().map(j -> j.validation()).filter(f -> f != null).collect(Collectors.toList());
    }

    public Collection<UUID> validationIds() {
        return this.jobs.values().stream().map(j -> j.validation()).filter(f -> f != null).map(v -> (UUID)v.id).collect(Collectors.toList());
    }

    public String toString() {
        Completable.Result result = this.getResult();
        return "ParticipateState{initiator=" + this.initiator + ", status=" + (result == null ? "pending" : result.toString()) + ", jobs=" + this.jobs.values() + "}";
    }

    public static class Job
    extends AbstractState<State, RepairJobDesc> {
        private final AtomicReference<ValidationState> validation = new AtomicReference<Object>(null);
        private final ConcurrentMap<SyncState.Id, SyncState> syncs = new ConcurrentHashMap<SyncState.Id, SyncState>();

        public Job(Clock clock, RepairJobDesc desc) {
            super(clock, desc, State.class);
        }

        @Override
        protected synchronized AbstractState.UpdateType maybeUpdateState(State state) {
            return super.maybeUpdateState(state);
        }

        public void snapshot() {
            this.updateState(State.SNAPSHOT);
        }

        public RegisterStatus register(ValidationState state) {
            return this.register(s2 -> this.validation.compareAndSet((ValidationState)null, (ValidationState)s2) ? null : this.validation(), State.VALIDATION, state);
        }

        @Nullable
        public ValidationState validation() {
            return this.validation.get();
        }

        public RegisterStatus register(SyncState state) {
            return this.register(s2 -> this.syncs.putIfAbsent((SyncState.Id)s2.id, (SyncState)s2), State.SYNC, state);
        }

        private <I, S extends AbstractState<?, I>> RegisterStatus register(Function<S, S> putter, State state, S value) {
            AbstractState.UpdateType updateType = this.maybeUpdateState(state);
            switch (updateType) {
                case ALREADY_COMPLETED: {
                    return RegisterStatus.ALREADY_COMPLETED;
                }
                case LARGER_STATE_SEEN: {
                    return RegisterStatus.STATUS_REJECTED;
                }
                case ACCEPTED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown status: " + updateType);
                }
            }
            AbstractState current = (AbstractState)putter.apply(value);
            return current == null ? RegisterStatus.ACCEPTED : RegisterStatus.EXISTS;
        }

        @Nullable
        public SyncState sync(SyncState.Id id) {
            return (SyncState)this.syncs.get(id);
        }

        @Override
        public String toString() {
            return super.toString();
        }

        public static enum State {
            ACCEPT,
            SNAPSHOT,
            VALIDATION,
            SYNC;

        }
    }

    public class Phase
    extends AbstractCompletable.BasePhase {
        public void accept() {
            ParticipateState.this.accepted = true;
        }
    }

    public static enum RegisterStatus {
        ACCEPTED,
        EXISTS,
        STATUS_REJECTED,
        ALREADY_COMPLETED;

    }
}

