/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.repair.BlockingReadRepair;
import org.apache.cassandra.service.reads.repair.ReadOnlyReadRepair;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.transport.Dispatcher;

public enum ReadRepairStrategy implements ReadRepair.Factory
{
    NONE{

        @Override
        public <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>> ReadRepair<E, P> create(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, Dispatcher.RequestTime requestTime) {
            return new ReadOnlyReadRepair<E, P>(command, replicaPlan, requestTime);
        }
    }
    ,
    BLOCKING{

        @Override
        public <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>> ReadRepair<E, P> create(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, Dispatcher.RequestTime requestTime) {
            return new BlockingReadRepair<E, P>(command, replicaPlan, requestTime);
        }
    };


    public static ReadRepairStrategy fromString(String s2) {
        return ReadRepairStrategy.valueOf(s2.toUpperCase());
    }
}

