/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.async;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ConnectionCategory;
import org.apache.cassandra.net.InternodeConnectionUtils;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundConnectionInitiator;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.async.NettyStreamingChannel;

public class NettyStreamingConnectionFactory
implements StreamingChannel.Factory {
    @VisibleForTesting
    public static int MAX_CONNECT_ATTEMPTS = 3;

    public static NettyStreamingChannel connect(OutboundConnectionSettings template, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        EventLoop eventLoop = MessagingService.instance().socketFactory.outboundStreamingGroup().next();
        OutboundConnectionSettings settings = template.withDefaults(ConnectionCategory.STREAMING);
        List<OutboundConnectionInitiator.SslFallbackConnectionType> sslFallbacks = settings.withEncryption() && settings.encryption.getOptional() != false ? Arrays.asList(OutboundConnectionInitiator.SslFallbackConnectionType.values()) : Collections.singletonList(OutboundConnectionInitiator.SslFallbackConnectionType.SERVER_CONFIG);
        Throwable cause = null;
        for (OutboundConnectionInitiator.SslFallbackConnectionType sslFallbackConnectionType : sslFallbacks) {
            for (int i = 0; i < MAX_CONNECT_ATTEMPTS; ++i) {
                Future<OutboundConnectionInitiator.Result<OutboundConnectionInitiator.Result.StreamingSuccess>> result = OutboundConnectionInitiator.initiateStreaming(eventLoop, settings, sslFallbackConnectionType);
                result.awaitUninterruptibly();
                if (result.isSuccess()) {
                    Channel channel = result.getNow().success().channel;
                    NettyStreamingChannel streamingChannel = new NettyStreamingChannel(channel, kind);
                    if (kind == StreamingChannel.Kind.CONTROL) {
                        ChannelPipeline pipeline = channel.pipeline();
                        pipeline.addLast("stream", (ChannelHandler)streamingChannel);
                    }
                    return streamingChannel;
                }
                cause = result.cause();
            }
            if (InternodeConnectionUtils.isSSLError(cause)) continue;
            break;
        }
        throw new IOException("failed to connect to " + template.to + " for streaming data", cause);
    }

    @Override
    public StreamingChannel create(InetSocketAddress to, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        return NettyStreamingConnectionFactory.connect(new OutboundConnectionSettings(InetAddressAndPort.getByAddress(to)), messagingVersion, kind);
    }

    @Override
    public StreamingChannel create(InetSocketAddress to, InetSocketAddress preferred, int messagingVersion, StreamingChannel.Kind kind) throws IOException {
        return NettyStreamingConnectionFactory.connect(new OutboundConnectionSettings(InetAddressAndPort.getByAddress(to), InetAddressAndPort.getByAddress(preferred)), messagingVersion, kind);
    }
}

