/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="statusautocompaction", description="status of autocompaction of the given keyspace and table")
public class StatusAutoCompaction
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="show_all", name={"-a", "--all"}, description="Show auto compaction status for each keyspace/table")
    private boolean showAll = false;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] tableNames = this.parseOptionalTables(this.args);
        boolean allDisabled = true;
        boolean allEnabled = true;
        TableBuilder table = new TableBuilder();
        table.add("Keyspace", "Table", "Status");
        try {
            for (String keyspace : keyspaces) {
                Map<String, Boolean> statuses = probe.getAutoCompactionDisabled(keyspace, tableNames);
                for (Map.Entry<String, Boolean> status : statuses.entrySet()) {
                    String tableName = status.getKey();
                    boolean disabled = status.getValue();
                    allDisabled &= disabled;
                    allEnabled &= !disabled;
                    table.add(keyspace, tableName, !disabled ? "running" : "not running");
                }
            }
            if (this.showAll) {
                table.printTo(probe.output().out);
            } else {
                probe.output().out.println(allEnabled ? "running" : (allDisabled ? "not running" : "partially running"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred during status-auto-compaction", e);
        }
    }
}

