/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class SpatialQuery
extends Query {
    final String field;
    final ShapeField.QueryRelation queryRelation;
    final Geometry[] geometries;
    final Component2D queryComponent2D;

    protected SpatialQuery(String field, ShapeField.QueryRelation queryRelation, Geometry ... geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (queryRelation == null) {
            throw new IllegalArgumentException("queryRelation must not be null");
        }
        this.field = field;
        this.queryRelation = queryRelation;
        this.geometries = (Geometry[])geometries.clone();
        this.queryComponent2D = this.createComponent2D(geometries);
    }

    protected abstract Component2D createComponent2D(Geometry ... var1);

    protected abstract SpatialVisitor getSpatialVisitor();

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    protected boolean queryIsCacheable(LeafReaderContext ctx) {
        return true;
    }

    protected ScorerSupplier getScorerSupplier(final LeafReader reader, SpatialVisitor spatialVisitor, final ScoreMode scoreMode, final ConstantScoreWeight weight, float boost, final float score) throws IOException {
        PointValues values = reader.getPointValues(this.field);
        if (values == null) {
            return null;
        }
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.field);
        if (fieldInfo == null) {
            return null;
        }
        PointValues.Relation rel = spatialVisitor.getInnerFunction(this.queryRelation).apply(values.getMinPackedValue(), values.getMaxPackedValue());
        if (rel == PointValues.Relation.CELL_OUTSIDE_QUERY || rel == PointValues.Relation.CELL_INSIDE_QUERY && this.queryRelation == ShapeField.QueryRelation.CONTAINS) {
            return null;
        }
        if (values.getDocCount() == reader.maxDoc() && rel == PointValues.Relation.CELL_INSIDE_QUERY) {
            return new ScorerSupplier(){

                @Override
                public Scorer get(long leadCost) {
                    return new ConstantScoreScorer((Weight)weight, score, scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                }

                @Override
                public long cost() {
                    return reader.maxDoc();
                }
            };
        }
        if (this.queryRelation != ShapeField.QueryRelation.INTERSECTS && this.queryRelation != ShapeField.QueryRelation.CONTAINS && (long)values.getDocCount() != values.size() && !SpatialQuery.hasAnyHits(spatialVisitor, this.queryRelation, values)) {
            return null;
        }
        return new RelationScorerSupplier(values, spatialVisitor, this.queryRelation, this.field){

            @Override
            public Scorer get(long leadCost) throws IOException {
                return this.getScorer(reader, weight, score, scoreMode);
            }
        };
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) {
        SpatialQuery query = this;
        final SpatialVisitor spatialVisitor = this.getSpatialVisitor();
        return new ConstantScoreWeight(query, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                return SpatialQuery.this.getScorerSupplier(reader, spatialVisitor, scoreMode, this, boost, this.score());
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return SpatialQuery.this.queryIsCacheable(ctx);
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public ShapeField.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.queryRelation.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((SpatialQuery)o).field) && this.queryRelation == ((SpatialQuery)o).queryRelation && Arrays.equals(this.geometries, ((SpatialQuery)o).geometries);
    }

    protected static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static PointValues.IntersectVisitor getEstimateVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void visit(int docID, byte[] t2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getSparseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final DocIdSetBuilder result) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate<byte[]> leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){
            DocIdSetBuilder.BulkAdder adder;

            @Override
            public void grow(int count) {
                this.adder = result.grow(count);
            }

            @Override
            public void visit(int docID) {
                this.adder.add(docID);
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                this.adder.add(iterator);
            }

            @Override
            public void visit(int docID, byte[] t2) {
                if (leafPredicate.test(t2)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) throws IOException {
                if (leafPredicate.test(t2)) {
                    this.adder.add(iterator);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getIntersectsDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final long[] cost) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate<byte[]> leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.set(docID);
                cost[0] = cost[0] + 1L;
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                result.or(iterator);
                cost[0] = cost[0] + iterator.cost();
            }

            @Override
            public void visit(int docID, byte[] t2) {
                if (!result.get(docID) && leafPredicate.test(t2)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) throws IOException {
                if (leafPredicate.test(t2)) {
                    this.visit(iterator);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final FixedBitSet excluded, final long[] cost) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate<byte[]> leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.set(docID);
                cost[0] = cost[0] + 1L;
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                result.or(iterator);
                cost[0] = cost[0] + iterator.cost();
            }

            @Override
            public void visit(int docID, byte[] t2) {
                if (!excluded.get(docID)) {
                    if (leafPredicate.test(t2)) {
                        this.visit(docID);
                    } else {
                        excluded.set(docID);
                    }
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) throws IOException {
                if (leafPredicate.test(t2)) {
                    this.visit(iterator);
                } else {
                    excluded.or(iterator);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getContainsDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final FixedBitSet excluded, final long[] cost) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Function<byte[], Component2D.WithinRelation> leafFunction = spatialVisitor.contains();
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                excluded.set(docID);
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                excluded.or(iterator);
            }

            @Override
            public void visit(int docID, byte[] t2) {
                if (!excluded.get(docID)) {
                    Component2D.WithinRelation within = (Component2D.WithinRelation)((Object)leafFunction.apply(t2));
                    if (within == Component2D.WithinRelation.CANDIDATE) {
                        cost[0] = cost[0] + 1L;
                        result.set(docID);
                    } else if (within == Component2D.WithinRelation.NOTWITHIN) {
                        excluded.set(docID);
                    }
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) throws IOException {
                int docID;
                Component2D.WithinRelation within = (Component2D.WithinRelation)((Object)leafFunction.apply(t2));
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (within == Component2D.WithinRelation.CANDIDATE) {
                        cost[0] = cost[0] + 1L;
                        result.set(docID);
                        continue;
                    }
                    if (within != Component2D.WithinRelation.NOTWITHIN) continue;
                    excluded.set(docID);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return (PointValues.Relation)((Object)innerFunction.apply(minTriangle, maxTriangle));
            }
        };
    }

    private static PointValues.IntersectVisitor getInverseDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result, final long[] cost) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        final Predicate<byte[]> leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.clear(docID);
                cost[0] = cost[0] - 1L;
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                result.andNot(iterator);
                cost[0] = Math.max(0L, cost[0] - iterator.cost());
            }

            @Override
            public void visit(int docID, byte[] packedTriangle) {
                if (result.get(docID) && !leafPredicate.test(packedTriangle)) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) throws IOException {
                if (!leafPredicate.test(t2)) {
                    this.visit(iterator);
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return SpatialQuery.transposeRelation((PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue)));
            }
        };
    }

    private static PointValues.IntersectVisitor getShallowInverseDenseVisitor(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, final FixedBitSet result) {
        final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
        return new PointValues.IntersectVisitor(){

            @Override
            public void visit(int docID) {
                result.clear(docID);
            }

            @Override
            public void visit(DocIdSetIterator iterator) throws IOException {
                result.andNot(iterator);
            }

            @Override
            public void visit(int docID, byte[] packedTriangle) {
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] t2) {
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return SpatialQuery.transposeRelation((PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue)));
            }
        };
    }

    private static boolean hasAnyHits(SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, PointValues values) throws IOException {
        try {
            final BiFunction<byte[], byte[], PointValues.Relation> innerFunction = spatialVisitor.getInnerFunction(queryRelation);
            final Predicate<byte[]> leafPredicate = spatialVisitor.getLeafPredicate(queryRelation);
            values.intersect(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    throw new CollectionTerminatedException();
                }

                @Override
                public void visit(int docID, byte[] t2) {
                    if (leafPredicate.test(t2)) {
                        throw new CollectionTerminatedException();
                    }
                }

                @Override
                public void visit(DocIdSetIterator iterator, byte[] t2) {
                    if (leafPredicate.test(t2)) {
                        throw new CollectionTerminatedException();
                    }
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    PointValues.Relation rel = (PointValues.Relation)((Object)innerFunction.apply(minPackedValue, maxPackedValue));
                    if (rel == PointValues.Relation.CELL_INSIDE_QUERY) {
                        throw new CollectionTerminatedException();
                    }
                    return rel;
                }
            });
        }
        catch (CollectionTerminatedException e) {
            return true;
        }
        return false;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static class EncodedRectangle {
        protected int minX;
        protected int maxX;
        protected int minY;
        protected int maxY;
        protected boolean wrapsCoordinateSystem;

        protected EncodedRectangle(int minX, int maxX, int minY, int maxY, boolean wrapsCoordinateSystem) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.wrapsCoordinateSystem = wrapsCoordinateSystem;
        }

        protected boolean wrapsCoordinateSystem() {
            return this.wrapsCoordinateSystem;
        }

        boolean contains(int x, int y) {
            if (y < this.minY || y > this.maxY) {
                return false;
            }
            if (this.wrapsCoordinateSystem()) {
                return !(x > this.maxX && x < this.minX);
            }
            return !(x > this.maxX || x < this.minX);
        }

        boolean intersectsLine(int aX, int aY, int bX, int bY) {
            if (this.contains(aX, aY) || this.contains(bX, bY)) {
                return true;
            }
            if (StrictMath.max(aY, bY) < this.minY || StrictMath.min(aY, bY) > this.maxY) {
                return false;
            }
            if (this.wrapsCoordinateSystem ? StrictMath.min(aX, bX) > this.maxX && StrictMath.max(aX, bX) < this.minX : StrictMath.min(aX, bX) > this.maxX || StrictMath.max(aX, bX) < this.minX) {
                return false;
            }
            return this.edgeIntersectsQuery(aX, aY, bX, bY);
        }

        boolean intersectsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return true;
            }
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (tMaxY < this.minY || tMinY > this.maxY) {
                return false;
            }
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            if (this.wrapsCoordinateSystem ? tMinX > this.maxX && tMaxX < this.minX : tMinX > this.maxX || tMaxX < this.minX) {
                return false;
            }
            return Component2D.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY) || this.edgeIntersectsQuery(aX, aY, bX, bY) || this.edgeIntersectsQuery(bX, bY, cX, cY) || this.edgeIntersectsQuery(cX, cY, aX, aY);
        }

        boolean intersectsRectangle(int minX, int maxX, int minY, int maxY) {
            if (this.minY > maxY || this.maxY < minY) {
                return false;
            }
            if (this.minX <= maxX && (this.wrapsCoordinateSystem || this.maxX >= minX)) {
                return true;
            }
            return this.wrapsCoordinateSystem;
        }

        boolean containsRectangle(int minX, int maxX, int minY, int maxY) {
            return this.minX <= minX && this.maxX >= maxX && this.minY <= minY && this.maxY >= maxY;
        }

        boolean containsLine(int aX, int aY, int bX, int bY) {
            if (aY < this.minY || bY < this.minY || aY > this.maxY || bY > this.maxY) {
                return false;
            }
            if (this.wrapsCoordinateSystem) {
                return aX >= this.minX && bX >= this.minX || aX <= this.maxX && bX <= this.maxX;
            }
            return aX >= this.minX && bX >= this.minX && aX <= this.maxX && bX <= this.maxX;
        }

        boolean containsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
            if (aY < this.minY || bY < this.minY || cY < this.minY || aY > this.maxY || bY > this.maxY || cY > this.maxY) {
                return false;
            }
            if (this.wrapsCoordinateSystem) {
                return aX >= this.minX && bX >= this.minX && cX >= this.minX || aX <= this.maxX && bX <= this.maxX && cX <= this.maxX;
            }
            return aX >= this.minX && bX >= this.minX && cX >= this.minX && aX <= this.maxX && bX <= this.maxX && cX <= this.maxX;
        }

        Component2D.WithinRelation withinLine(int aX, int aY, boolean ab, int bX, int bY) {
            if (this.contains(aX, aY) || this.contains(bX, bY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            if (ab && EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, this.maxX, this.minY, this.maxY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            return Component2D.WithinRelation.DISJOINT;
        }

        Component2D.WithinRelation withinTriangle(int aX, int aY, boolean ab, int bX, int bY, boolean bc, int cX, int cY, boolean ca) {
            if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (tMaxY < this.minY || tMinY > this.maxY) {
                return Component2D.WithinRelation.DISJOINT;
            }
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            if (this.wrapsCoordinateSystem ? tMinX > this.maxX && tMaxX < this.minX : tMinX > this.maxX || tMaxX < this.minX) {
                return Component2D.WithinRelation.DISJOINT;
            }
            Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
            if (EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ab) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(bX, bY, cX, cY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (bc) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(cX, cY, aX, aY, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ca) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (relation == Component2D.WithinRelation.CANDIDATE || Component2D.pointInTriangle(tMinX, tMaxX, tMinY, tMaxY, this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            return relation;
        }

        private boolean edgeIntersectsQuery(int aX, int aY, int bX, int bY) {
            if (this.wrapsCoordinateSystem) {
                return EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
            }
            return EncodedRectangle.edgeIntersectsBox(aX, aY, bX, bY, this.minX, this.maxX, this.minY, this.maxY);
        }

        private static boolean edgeIntersectsBox(int aX, int aY, int bX, int bY, int minX, int maxX, int minY, int maxY) {
            if (Math.max(aX, bX) < minX || Math.min(aX, bX) > maxX || Math.min(aY, bY) > maxY || Math.max(aY, bY) < minY) {
                return false;
            }
            return GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, minX, maxY, maxX, maxY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, maxX, maxY, maxX, minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, maxX, minY, minX, minY) || GeoUtils.lineCrossesLineWithBoundary(aX, aY, bX, bY, minX, minY, minX, maxY);
        }
    }

    private static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        private final PointValues values;
        private final SpatialVisitor spatialVisitor;
        private final ShapeField.QueryRelation queryRelation;
        private final String field;
        private long cost = -1L;

        RelationScorerSupplier(PointValues values, SpatialVisitor spatialVisitor, ShapeField.QueryRelation queryRelation, String field) {
            this.values = values;
            this.spatialVisitor = spatialVisitor;
            this.queryRelation = queryRelation;
            this.field = field;
        }

        protected Scorer getScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            switch (this.queryRelation) {
                case INTERSECTS: {
                    return this.getSparseScorer(reader, weight, boost, scoreMode);
                }
                case CONTAINS: {
                    return this.getContainsDenseScorer(reader, weight, boost, scoreMode);
                }
                case WITHIN: 
                case DISJOINT: {
                    return (long)this.values.getDocCount() == this.values.size() ? this.getSparseScorer(reader, weight, boost, scoreMode) : this.getDenseScorer(reader, weight, boost, scoreMode);
                }
            }
            throw new IllegalArgumentException("Unsupported query type :[" + this.queryRelation + "]");
        }

        private Scorer getSparseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            if (this.queryRelation == ShapeField.QueryRelation.DISJOINT && this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                result.set(0, reader.maxDoc());
                long[] cost = new long[]{reader.maxDoc()};
                this.values.intersect(SpatialQuery.getInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
                BitSetIterator iterator = new BitSetIterator(result, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
            }
            if ((long)this.values.getDocCount() < this.values.size() >>> 2) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                long[] cost = new long[]{0L};
                this.values.intersect(SpatialQuery.getIntersectsDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
                assert (cost[0] > 0L || result.cardinality() == 0);
                DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
            }
            DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(reader.maxDoc(), this.values, this.field);
            this.values.intersect(SpatialQuery.getSparseVisitor(this.spatialVisitor, this.queryRelation, docIdSetBuilder));
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        private Scorer getDenseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            long[] cost;
            FixedBitSet result = new FixedBitSet(reader.maxDoc());
            if (this.values.getDocCount() == reader.maxDoc()) {
                cost = new long[]{this.values.size()};
                result.set(0, reader.maxDoc());
                this.values.intersect(SpatialQuery.getInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result, cost));
            } else {
                cost = new long[]{0L};
                FixedBitSet excluded = new FixedBitSet(reader.maxDoc());
                this.values.intersect(SpatialQuery.getDenseVisitor(this.spatialVisitor, this.queryRelation, result, excluded, cost));
                result.andNot(excluded);
                this.values.intersect(SpatialQuery.getShallowInverseDenseVisitor(this.spatialVisitor, this.queryRelation, result));
            }
            assert (cost[0] > 0L || result.cardinality() == 0);
            DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        private Scorer getContainsDenseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            FixedBitSet result = new FixedBitSet(reader.maxDoc());
            long[] cost = new long[]{0L};
            FixedBitSet excluded = new FixedBitSet(reader.maxDoc());
            this.values.intersect(SpatialQuery.getContainsDenseVisitor(this.spatialVisitor, this.queryRelation, result, excluded, cost));
            result.andNot(excluded);
            assert (cost[0] > 0L || result.cardinality() == 0);
            DocIdSetIterator iterator = cost[0] == 0L ? DocIdSetIterator.empty() : new BitSetIterator(result, cost[0]);
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.values.estimateDocCount(SpatialQuery.getEstimateVisitor(this.spatialVisitor, this.queryRelation));
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }

    protected static abstract class SpatialVisitor {
        protected SpatialVisitor() {
        }

        protected abstract PointValues.Relation relate(byte[] var1, byte[] var2);

        protected abstract Predicate<byte[]> intersects();

        protected abstract Predicate<byte[]> within();

        protected abstract Function<byte[], Component2D.WithinRelation> contains();

        private Predicate<byte[]> containsPredicate() {
            Function<byte[], Component2D.WithinRelation> contains = this.contains();
            return bytes -> contains.apply((byte[])bytes) == Component2D.WithinRelation.CANDIDATE;
        }

        private BiFunction<byte[], byte[], PointValues.Relation> getInnerFunction(ShapeField.QueryRelation queryRelation) {
            if (queryRelation == ShapeField.QueryRelation.DISJOINT) {
                return (minPackedValue, maxPackedValue) -> SpatialQuery.transposeRelation(this.relate((byte[])minPackedValue, (byte[])maxPackedValue));
            }
            return (minPackedValue, maxPackedValue) -> this.relate((byte[])minPackedValue, (byte[])maxPackedValue);
        }

        private Predicate<byte[]> getLeafPredicate(ShapeField.QueryRelation queryRelation) {
            switch (queryRelation) {
                case INTERSECTS: {
                    return this.intersects();
                }
                case WITHIN: {
                    return this.within();
                }
                case DISJOINT: {
                    return this.intersects().negate();
                }
                case CONTAINS: {
                    return this.containsPredicate();
                }
            }
            throw new IllegalArgumentException("Unsupported query type :[" + queryRelation + "]");
        }
    }
}

