/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.util.Arrays;
import java.util.List;
import org.github.jamm.FieldAndClassFilter;
import org.github.jamm.FieldFilter;
import org.github.jamm.Unmetered;

public final class Filters {
    private static final String OUTER_CLASS_REFERENCE = "this\\$[0-9]+";
    private static final List<String> CLEANER_FIELDS_TO_IGNORE = Arrays.asList("queue", "prev", "next");
    private static final Class<?> CLEANER_CLASS = Filters.getCleanerClass();
    public static final FieldFilter IGNORE_STATIC_AND_PRIMITIVE_FIELDS = (c, f) -> Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive();
    public static final FieldAndClassFilter IGNORE_KNOWN_SINGLETONS = c -> Class.class.equals((Object)c) || Enum.class.isAssignableFrom(c) || ClassLoader.class.isAssignableFrom(c) || AccessControlContext.class.isAssignableFrom(c);
    public static final FieldFilter IGNORE_NON_STRONG_REFERENCES = (c, f) -> f.getDeclaringClass().equals(Reference.class) || ReferenceQueue.class.isAssignableFrom(c) && "head".equals(f.getName());
    public static final FieldFilter IGNORE_CLEANER_FIELDS = (c, f) -> c.equals(CLEANER_CLASS) && CLEANER_FIELDS_TO_IGNORE.contains(f.getName());
    public static final FieldFilter IGNORE_THREAD_FIELDS = (c, f) -> c.equals(Thread.class) && "group".equals(f.getName());
    public static final FieldFilter IGNORE_OUTER_CLASS_REFERENCES = (c, f) -> f.getName().matches(OUTER_CLASS_REFERENCE);
    public static final FieldAndClassFilter IGNORE_UNMETERED_FIELDS_AND_CLASSES = new FieldAndClassFilter(){

        @Override
        public boolean ignore(Class<?> cls, Field field) {
            return field.isAnnotationPresent(Unmetered.class) || this.ignore(field.getType());
        }

        @Override
        public boolean ignore(Class<?> cls) {
            return cls != null && (cls.isAnnotationPresent(Unmetered.class) || this.isAnnotationPresentOnInterfaces(cls));
        }

        private boolean isAnnotationPresentOnInterfaces(Class<?> cls) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!cls.getInterfaces()[i].isAnnotationPresent(Unmetered.class)) continue;
                return true;
            }
            return false;
        }
    };

    private static Class<?> getCleanerClass() {
        try {
            return ByteBuffer.allocateDirect(0).getClass().getDeclaredField("cleaner").getType();
        }
        catch (Exception e) {
            System.out.print("WARN: Jamm could not load the sun.misc.Cleaner Class. This might lead to overestimating DirectByteBuffer size.");
            return null;
        }
    }

    public static FieldAndClassFilter getClassFilters(boolean ignoreKnownSingletons) {
        if (ignoreKnownSingletons) {
            return new FieldAndClassFilter(){

                @Override
                public boolean ignore(Class<?> cls, Field field) {
                    return IGNORE_KNOWN_SINGLETONS.ignore(cls, field) || IGNORE_UNMETERED_FIELDS_AND_CLASSES.ignore(cls, field);
                }

                @Override
                public boolean ignore(Class<?> cls) {
                    return IGNORE_KNOWN_SINGLETONS.ignore(cls) || IGNORE_UNMETERED_FIELDS_AND_CLASSES.ignore(cls);
                }
            };
        }
        return IGNORE_UNMETERED_FIELDS_AND_CLASSES;
    }

    public static FieldFilter getFieldFilters(boolean ignoreKnownSingletons, boolean ignoreOuterClassReference, boolean ignoreNonStrongReferences) {
        if (ignoreOuterClassReference) {
            if (ignoreNonStrongReferences) {
                return (c, f) -> IGNORE_STATIC_AND_PRIMITIVE_FIELDS.ignore(c, f) || Filters.getClassFilters(ignoreKnownSingletons).ignore(c, f) || IGNORE_CLEANER_FIELDS.ignore(c, f) || IGNORE_THREAD_FIELDS.ignore(c, f) || IGNORE_NON_STRONG_REFERENCES.ignore(c, f) || IGNORE_OUTER_CLASS_REFERENCES.ignore(c, f);
            }
            return (c, f) -> IGNORE_STATIC_AND_PRIMITIVE_FIELDS.ignore(c, f) || Filters.getClassFilters(ignoreKnownSingletons).ignore(c, f) || IGNORE_CLEANER_FIELDS.ignore(c, f) || IGNORE_THREAD_FIELDS.ignore(c, f) || IGNORE_OUTER_CLASS_REFERENCES.ignore(c, f);
        }
        if (ignoreNonStrongReferences) {
            return (c, f) -> IGNORE_STATIC_AND_PRIMITIVE_FIELDS.ignore(c, f) || Filters.getClassFilters(ignoreKnownSingletons).ignore(c, f) || IGNORE_CLEANER_FIELDS.ignore(c, f) || IGNORE_THREAD_FIELDS.ignore(c, f) || IGNORE_NON_STRONG_REFERENCES.ignore(c, f);
        }
        return (c, f) -> IGNORE_STATIC_AND_PRIMITIVE_FIELDS.ignore(c, f) || Filters.getClassFilters(ignoreKnownSingletons).ignore(c, f) || IGNORE_CLEANER_FIELDS.ignore(c, f) || IGNORE_THREAD_FIELDS.ignore(c, f);
    }

    private Filters() {
    }
}

