/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Predicate;
import org.github.jamm.CannotMeasureObjectException;
import org.github.jamm.VM;
import org.github.jamm.strategies.ContentionGroupsCounter;
import org.github.jamm.utils.MethodHandleUtils;

final class ContendedUtils {
    private static final boolean CONTENDED_ENABLED = VM.enableContended();
    private static final boolean CONTENDED_RESTRICTED = VM.restrictContended();
    private static final Class<? extends Annotation> CONTENDED_CLASS = ContendedUtils.loadContendedClass();
    private static final Optional<MethodHandle> MAY_BE_CONTENDED_VALUE_MH = MethodHandleUtils.mayBeMethodHandle(CONTENDED_CLASS, "value");
    private static final Predicate<ClassLoader> PLATFORM_PREDICATE = ContendedUtils.platformClassLoaderPredicate();

    ContendedUtils() {
    }

    public static boolean isClassAnnotatedWithContended(Class<?> type) {
        return type.isAnnotationPresent(CONTENDED_CLASS);
    }

    public static boolean isFieldAnnotatedWithContended(Field f) {
        return f.isAnnotationPresent(CONTENDED_CLASS);
    }

    private static Object getContendedAnnotation(Field f) {
        return f.getAnnotation(CONTENDED_CLASS);
    }

    public static ContentionGroupsCounter countContentionGroup(ContentionGroupsCounter counter, Field f) {
        if (ContendedUtils.isFieldAnnotatedWithContended(f)) {
            String tag = ContendedUtils.getContentionGroupTag(f);
            if (counter == null) {
                counter = new ContentionGroupsCounter();
            }
            counter.add(tag);
        }
        return counter;
    }

    public static String getContentionGroupTag(Field f) {
        try {
            if (MAY_BE_CONTENDED_VALUE_MH.isPresent()) {
                return MAY_BE_CONTENDED_VALUE_MH.get().invoke(ContendedUtils.getContendedAnnotation(f));
            }
        }
        catch (Throwable e) {
            throw new CannotMeasureObjectException("The field " + f.getName() + " from the class " + f.getDeclaringClass() + "cannot be measured.", e);
        }
        if (f.getDeclaringClass().equals(Thread.class)) {
            return "tlr";
        }
        throw new CannotMeasureObjectException("The field " + f.getName() + " from the class " + f.getDeclaringClass() + "cannot be measured as the @Contended contention group tag cannot be retrieved. Consider using: --add-exports java.base/jdk.internal.vm.annotation=ALL-UNNAMED to remove that problem");
    }

    private static boolean isTrustedClass(Class<?> cls) {
        ClassLoader classLoader = cls.getClassLoader();
        return classLoader == null || PLATFORM_PREDICATE.test(classLoader);
    }

    public static boolean isContendedEnabled(Class<?> cls) {
        return CONTENDED_ENABLED && (ContendedUtils.isTrustedClass(cls) || !CONTENDED_RESTRICTED);
    }

    private static Class<? extends Annotation> loadContendedClass() {
        try {
            return Class.forName("sun.misc.Contended");
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("jdk.internal.vm.annotation.Contended");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("The Contended annotation class could not be loaded.", ex);
            }
        }
    }

    private static Predicate<ClassLoader> platformClassLoaderPredicate() {
        Optional<MethodHandle> mayBeMethodHandle = MethodHandleUtils.mayBeMethodHandle(ClassLoader.class, "getPlatformClassLoader()");
        if (mayBeMethodHandle.isPresent()) {
            try {
                ClassLoader platformClassLoader = mayBeMethodHandle.get().invoke();
                return cl -> platformClassLoader == cl;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return cl -> cl.toString().startsWith("sun.misc.Launcher$ExtClassLoader");
    }
}

