/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ContentionGroupsCounter {
    private static final String ANONYMOUS_GROUP = "";
    private int anonymousCounter;
    private Set<String> contentionGroups = Collections.emptySet();

    ContentionGroupsCounter() {
    }

    public void add(String contentionGroupTag) {
        if (ANONYMOUS_GROUP.equals(contentionGroupTag)) {
            ++this.anonymousCounter;
        } else {
            if (this.contentionGroups.isEmpty()) {
                this.contentionGroups = new HashSet<String>();
            }
            this.contentionGroups.add(contentionGroupTag);
        }
    }

    public int count() {
        return this.anonymousCounter + this.contentionGroups.size();
    }

    public String toString() {
        return "ContentionGroupsCounter [anonymousCounter=" + this.anonymousCounter + ", contentionGroups=" + this.contentionGroups + "]";
    }
}

