/*
 * Decompiled with CFR 0.152.
 */
package org.perfkit.sjk.jfr.mcparser;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.openjdk.jmc.flightrecorder.internal.IChunkSupplier;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.VersionNotSupportedException;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkLoaderV0;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkLoaderV1;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;

public class JFRLoader {
    private static final Logger LOGGER = Logger.getLogger(JFRLoader.class.getName());
    private static final short VERSION_0 = 0;
    private static final short VERSION_1 = 1;
    private static final short VERSION_2 = 2;
    private static final byte[] FLIGHT_RECORDER_MAGIC = new byte[]{70, 76, 82, 0};

    public static EventArray[] loadStream(InputStream stream, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        return JFRLoader.loadStream(stream, ParserExtensionRegistry.getParserExtensions(), hideExperimentals, ignoreTruncatedChunk);
    }

    public static EventArray[] loadStream(InputStream stream, List<? extends IParserExtension> extensions, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        return JFRLoader.readChunks(extensions, JFRLoader.createChunkSupplier(stream), hideExperimentals, ignoreTruncatedChunk);
    }

    private static IChunkSupplier createChunkSupplier(final InputStream input) throws CouldNotLoadRecordingException, IOException {
        return new IChunkSupplier(){

            @Override
            public Chunk getNextChunk(byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
                int value = input.read();
                if (value < 0) {
                    return null;
                }
                return JFRLoader.createChunkInput(new DataInputStream(input), value, reusableBuffer);
            }
        };
    }

    private static Chunk createChunkInput(DataInput input, int firstByte, byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
        int i = 0;
        while (FLIGHT_RECORDER_MAGIC[i] == firstByte) {
            if (++i == FLIGHT_RECORDER_MAGIC.length) {
                return new Chunk(input, FLIGHT_RECORDER_MAGIC.length, reusableBuffer);
            }
            firstByte = input.readUnsignedByte();
        }
        throw new InvalidJfrFileException();
    }

    private static EventArray[] readChunks(List<? extends IParserExtension> extensions, IChunkSupplier chunkSupplier, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        LoaderContext context = new LoaderContext(extensions, hideExperimentals);
        int chunkCount = 0;
        try {
            IChunkLoader chunkLoader;
            byte[] buffer = new byte[]{};
            while ((chunkLoader = JFRLoader.createChunkLoader(chunkSupplier, context, buffer, ignoreTruncatedChunk)) != null) {
                try {
                    chunkLoader.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
                ++chunkCount;
            }
            if (chunkCount == 0) {
                throw new InvalidJfrFileException("No readable chunks in recording");
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof CouldNotLoadRecordingException) {
                throw (CouldNotLoadRecordingException)cause;
            }
            throw new CouldNotLoadRecordingException(cause);
        }
        return context.buildEventArrays();
    }

    private static IChunkLoader createChunkLoader(IChunkSupplier chunkSupplier, LoaderContext context, byte[] buffer, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        try {
            Chunk chunk = chunkSupplier.getNextChunk(buffer);
            if (chunk != null) {
                switch (chunk.getMajorVersion()) {
                    case 0: {
                        return ChunkLoaderV0.create(chunk, context);
                    }
                    case 1: 
                    case 2: {
                        return ChunkLoaderV1.create(chunk, context);
                    }
                }
                throw new VersionNotSupportedException();
            }
        }
        catch (IOException e) {
            if (ignoreTruncatedChunk) {
                LOGGER.log(Level.INFO, "Ignoring exception while reading chunk", e);
            }
            throw e;
        }
        return null;
    }
}

