/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.geometry.convexhull;

import java.util.Comparator;
import org.psjava.algo.geometry.convexhull.ConvexHullAlgorithm;
import org.psjava.algo.sequence.sort.SortingAlgorithm;
import org.psjava.ds.array.Array;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.array.MergedArray;
import org.psjava.ds.array.MutableArray;
import org.psjava.ds.array.MutableArrayFromIterable;
import org.psjava.ds.array.RotatedArray;
import org.psjava.ds.array.SubArray;
import org.psjava.ds.geometry.Point2D;
import org.psjava.ds.geometry.PointByXComparator;
import org.psjava.ds.geometry.PointByYComparator;
import org.psjava.ds.geometry.Polygon2D;
import org.psjava.ds.numbersystrem.MultipliableNumberSystem;
import org.psjava.ds.set.Set;
import org.psjava.formula.MaxIndexInArray;
import org.psjava.formula.MinIndexInArray;
import org.psjava.formula.geometry.LeftTurn;
import org.psjava.formula.geometry.RightTurn;
import org.psjava.formula.geometry.StraightOrder;
import org.psjava.util.AssertStatus;
import org.psjava.util.Index2D;
import org.psjava.util.ReversedComparator;
import org.psjava.util.SeriesComparator;

public class DivideAndConquerConvexHull {
    public static ConvexHullAlgorithm getInstance(final SortingAlgorithm sortingAlgorithm) {
        return new ConvexHullAlgorithm(){

            @Override
            public <T> Polygon2D<T> calc(Set<Point2D<T>> src, MultipliableNumberSystem<T> ns) {
                AssertStatus.assertTrue(!src.isEmpty(), "points must not be empty");
                Comparator<Point2D<T>> xcomp = PointByXComparator.create(ns);
                Comparator<Point2D<T>> ycomp = PointByYComparator.create(ns);
                Comparator xycomp = SeriesComparator.create(xcomp, ycomp);
                Comparator xrycomp = SeriesComparator.create(xcomp, ReversedComparator.wrap(ycomp));
                MutableArray<Point2D<T>> array = MutableArrayFromIterable.create(src);
                sortingAlgorithm.sort(array, xycomp);
                Array hullPoints = DivideAndConquerConvexHull.getConvexHullPointsRecursively(array, 0, array.size(), xycomp, xrycomp, ns);
                return Polygon2D.create(hullPoints);
            }
        };
    }

    private static <T> Array<Point2D<T>> getConvexHullPointsRecursively(Array<Point2D<T>> src, int start, int end, Comparator<Point2D<T>> xycomp, Comparator<Point2D<T>> xrycomp, MultipliableNumberSystem<T> ns) {
        if (end - start <= 2) {
            return SubArray.wrap(src, start, end);
        }
        int m4 = (start + end) / 2;
        Array<Point2D<T>> left = DivideAndConquerConvexHull.getConvexHullPointsRecursively(src, start, m4, xycomp, xrycomp, ns);
        Array<Point2D<T>> right = DivideAndConquerConvexHull.getConvexHullPointsRecursively(src, m4, end, xycomp, xrycomp, ns);
        return DivideAndConquerConvexHull.merge(left, right, xycomp, xrycomp, ns);
    }

    private static <T> Array<Point2D<T>> merge(Array<Point2D<T>> left, Array<Point2D<T>> right, Comparator<Point2D<T>> xycomp, Comparator<Point2D<T>> xrycomp, MultipliableNumberSystem<T> ns) {
        int leftUp = MaxIndexInArray.get(left, xycomp);
        int leftDown = MaxIndexInArray.get(left, xrycomp);
        int rightUp = MinIndexInArray.get(right, xrycomp);
        int rightDown = MinIndexInArray.get(right, xycomp);
        Index2D upIndex = DivideAndConquerConvexHull.findBridgeIndexes(right, left, rightUp, leftUp, ns);
        Index2D downIndex = DivideAndConquerConvexHull.findBridgeIndexes(left, right, leftDown, rightDown, ns);
        Array<Point2D<T>> leftHalf = DivideAndConquerConvexHull.wrapToRotatingSubArray(left, upIndex.i2, downIndex.i1);
        Array<Point2D<T>> rightHalf = DivideAndConquerConvexHull.wrapToRotatingSubArray(right, downIndex.i2, upIndex.i1);
        Array<Point2D<T>> hullPoints = DivideAndConquerConvexHull.getPointsWithoutOnLine(MergedArray.wrap(leftHalf, rightHalf), ns);
        return hullPoints;
    }

    private static <T> Index2D findBridgeIndexes(Array<Point2D<T>> earlyHull, Array<Point2D<T>> laterHull, int earlyStart, int laterStart, MultipliableNumberSystem<T> ns) {
        int early = earlyStart;
        int later = laterStart;
        while (true) {
            int nextEarly = DivideAndConquerConvexHull.getPreIndex(early, earlyHull.size());
            int nextLater = DivideAndConquerConvexHull.getNextIndex(later, laterHull.size());
            if (LeftTurn.is(laterHull.get(later), earlyHull.get(early), earlyHull.get(nextEarly), ns)) {
                early = nextEarly;
                continue;
            }
            if (!RightTurn.is(earlyHull.get(early), laterHull.get(later), laterHull.get(nextLater), ns)) break;
            later = nextLater;
        }
        return new Index2D(early, later);
    }

    private static <T> Array<Point2D<T>> getPointsWithoutOnLine(Array<Point2D<T>> src, MultipliableNumberSystem<T> ns) {
        if (src.size() < 3) {
            return src;
        }
        DynamicArray<Point2D<Point2D<T>>> r = DynamicArray.create();
        int n = src.size();
        for (int i = 0; i < n; ++i) {
            Point2D<T> pre = src.get(DivideAndConquerConvexHull.getPreIndex(i, n));
            Point2D<T> next = src.get(DivideAndConquerConvexHull.getNextIndex(i, n));
            if (StraightOrder.is(pre, src.get(i), next, ns)) continue;
            r.addToLast(src.get(i));
        }
        return r;
    }

    private static int getNextIndex(int index, int size) {
        return (index + 1) % size;
    }

    private static int getPreIndex(int index, int size) {
        return (index - 1 + size) % size;
    }

    private static <T> Array<T> wrapToRotatingSubArray(Array<T> a, int from, int to) {
        int length = (to - from + a.size()) % a.size() + 1;
        return SubArray.wrap(RotatedArray.wrap(a, from), 0, length);
    }

    private DivideAndConquerConvexHull() {
    }
}

