/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.spark.stats.BufferingInputStreamStats;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.streaming.StreamBuffer;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcRandomAccessReader
extends RandomAccessReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcRandomAccessReader.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    final CommitLog log;

    public CdcRandomAccessReader(CommitLog log) {
        super((Rebufferer)new CDCRebuffer(log));
        this.log = log;
    }

    public String getPath() {
        return this.log.path();
    }

    public static class BlockingStreamConsumer
    implements StreamConsumer {
        private final List<StreamBuffer> buffers;
        private final CompletableFuture<List<StreamBuffer>> future = new CompletableFuture();

        BlockingStreamConsumer() {
            this.buffers = new ArrayList<StreamBuffer>();
        }

        public synchronized void onRead(StreamBuffer buffer) {
            this.buffers.add(buffer);
        }

        public synchronized void onEnd() {
            this.future.complete(this.buffers);
        }

        public void onError(Throwable t) {
            this.future.completeExceptionally(t);
        }

        public void getBytes(ByteBuffer dst) {
            try {
                for (StreamBuffer buffer : this.future.get()) {
                    buffer.getBytes(0, dst, buffer.readableBytes());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(ThrowableUtils.rootCause((Throwable)e));
            }
        }
    }

    public static class CDCRebuffer
    implements Rebufferer,
    Rebufferer.BufferHolder {
        ByteBuffer buffer;
        final CommitLog log;
        final int chunkSize;
        long offset = 0L;
        final CassandraFileSource<CommitLog> source;
        private final BufferingInputStream<CommitLog> inputStream;

        CDCRebuffer(CommitLog log) {
            this(log, 4096);
        }

        CDCRebuffer(CommitLog log, int chunkSize) {
            Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"Chunk size must be a positive integer");
            this.log = log;
            this.chunkSize = chunkSize;
            this.buffer = ByteBuffer.allocate(this.bufferSize());
            this.source = log.source();
            this.inputStream = new BufferingInputStream(this.source, (BufferingInputStreamStats)log.stats());
        }

        private int bufferSize() {
            return Math.toIntExact(Math.min(this.log.maxOffset() - this.offset, (long)this.chunkSize));
        }

        public Rebufferer.BufferHolder rebuffer(long l) {
            this.offset = l;
            this.buffer.clear();
            int len = this.bufferSize();
            if (len < 0) {
                throw new IllegalStateException(String.format("Read passed maxOffset offset=%d maxOffset=%d", this.offset, this.log.maxOffset()));
            }
            if (this.buffer.capacity() != len) {
                this.buffer = ByteBuffer.allocate(len);
            }
            long currentPos = this.inputStream.bytesRead();
            try {
                if (this.offset < currentPos) {
                    int requestLen = this.buffer.remaining() + 1;
                    long end = this.offset + (long)requestLen;
                    BlockingStreamConsumer streamConsumer = new BlockingStreamConsumer();
                    this.source.request(this.offset, end, (StreamConsumer)streamConsumer);
                    streamConsumer.getBytes(this.buffer);
                    this.buffer.flip();
                    return this;
                }
                if (this.offset > currentPos) {
                    ByteBufferUtils.skipFully(this.inputStream, (long)(this.offset - currentPos));
                }
                this.inputStream.read(this.buffer);
                assert (this.buffer.remaining() == 0);
                this.buffer.flip();
            }
            catch (IOException e) {
                throw new RuntimeException(ThrowableUtils.rootCause((Throwable)e));
            }
            return this;
        }

        public void closeReader() {
            this.offset = -1L;
            this.close();
        }

        public void close() {
            assert (this.offset == -1L);
            this.inputStream.close();
            try {
                this.log.close();
            }
            catch (Exception e) {
                LOGGER.error("Exception closing CommitLog", (Throwable)e);
            }
            this.buffer = null;
        }

        public ChannelProxy channel() {
            throw new IllegalStateException("Channel method should not be used");
        }

        public long fileLength() {
            return this.log.maxOffset();
        }

        public double getCrcCheckChance() {
            return 0.0;
        }

        public ByteBuffer buffer() {
            return this.buffer;
        }

        public long offset() {
            return this.offset;
        }

        public void release() {
        }
    }
}

