/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.nio.ByteBuffer;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.jetbrains.annotations.NotNull;

interface BinaryFeatures
extends SparkType {
    @Override
    default public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return ByteBufferUtils.getArray((ByteBuffer)((ByteBuffer)value));
    }

    @Override
    default public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.BinaryType;
    }

    @Override
    default public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.getBinary(position);
    }

    @Override
    default public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.getAs(position);
    }

    @Override
    default public Object toTestRowType(Object value) {
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        return value;
    }

    @Override
    default public int compareTo(Object first, Object second) {
        return CqlField.BYTE_ARRAY_COMPARATOR.compare((byte[])first, (byte[])second);
    }
}

