/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.bridge.CassandraVersionFeatures;
import org.apache.cassandra.bridge.SSTableDescriptor;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.MockBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SSTables;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.cassandra.spark.utils.XXHash32DigestAlgorithm;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SortedSSTableWriterTest {
    private static String previousMbeanState;
    @NotNull
    private final TokenRangeMapping<RingInstance> tokenRangeMapping = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"DC1", (Object)3), 12);
    @TempDir
    private Path tmpDir;

    /*
     * Exception decompiling
     */
    public static Iterable<Object[]> supportedVersions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeAll
    public static void setProps() {
        previousMbeanState = System.getProperty("org.apache.cassandra.disable_mbean_registration");
        System.setProperty("org.apache.cassandra.disable_mbean_registration", "true");
    }

    @AfterAll
    public static void restoreProps() {
        if (previousMbeanState != null) {
            System.setProperty("org.apache.cassandra.disable_mbean_registration", previousMbeanState);
        } else {
            System.clearProperty("org.apache.cassandra.disable_mbean_registration");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void canCreateWriterForVersion(String version) throws IOException {
        MockBulkWriterContext writerContext = new MockBulkWriterContext(this.tokenRangeMapping, version, ConsistencyLevel.CL.LOCAL_QUORUM);
        SortedSSTableWriter tw = new SortedSSTableWriter((BulkWriterContext)writerContext, this.tmpDir, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        ArrayList allSSTables = new ArrayList();
        tw.setSSTablesProducedListener(allSSTables::addAll);
        tw.addRow(BigInteger.ONE, (Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"date", (Object)1, (Object)"course", (Object)"foo", (Object)"marks", (Object)1));
        tw.close((BulkWriterContext)writerContext);
        Assertions.assertThat(allSSTables).hasSize(1);
        String baseFileName = ((SSTableDescriptor)allSSTables.get((int)0)).baseFilename;
        CassandraVersionFeatures cvf = CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)version);
        switch (cvf.getMajorVersion()) {
            case 40: 
            case 41: {
                Assertions.assertThat((String)baseFileName).matches((CharSequence)"nb-\\d+-big");
                break;
            }
            case 50: {
                if ("big".equals(CassandraVersion.sstableFormat())) {
                    Assertions.assertThat((String)baseFileName).matches((CharSequence)"oa-\\d+-big");
                    break;
                }
                Assertions.assertThat((String)baseFileName).matches((CharSequence)"da-\\d+-bti");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported version: " + version);
            }
        }
        HashSet dataFilePaths = new HashSet();
        try (DirectoryStream<Path> dataFileStream = Files.newDirectoryStream(tw.getOutDir(), "*Data.db");){
            dataFileStream.forEach(dataFilePath -> {
                dataFilePaths.add(dataFilePath);
                Assertions.assertThat((int)SSTables.cassandraVersionFromTable(dataFilePath).getMajorVersion()).isEqualTo(CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion((String)version).getMajorVersion());
            });
        }
        tw.validateSSTables((BulkWriterContext)writerContext);
        tw.validateSSTables((BulkWriterContext)writerContext, tw.getOutDir(), dataFilePaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testConcurrentPrepareSStablesToSendAndClose(String version) throws Exception {
        MockBulkWriterContext writerContext = new MockBulkWriterContext(this.tokenRangeMapping, version, ConsistencyLevel.CL.LOCAL_QUORUM);
        List<SSTableDescriptor> existingSSTables = this.mockSSTableProduced(writerContext);
        ((ListAssert)Assertions.assertThat(existingSSTables).as("Should have produced SSTables", new Object[0])).isNotEmpty();
        SortedSSTableWriter testWriter = new SortedSSTableWriter((BulkWriterContext)writerContext, this.tmpDir, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        testWriter.setSSTablesProducedListener(x -> {});
        testWriter.addRow(BigInteger.valueOf(100L), (Map)ImmutableMap.of((Object)"id", (Object)2, (Object)"date", (Object)2, (Object)"course", (Object)"test2", (Object)"marks", (Object)200));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch completionLatch = new CountDownLatch(2);
            Future<?> prepareFuture = executor.submit(() -> {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                try {
                    for (int i = 0; i < 50; ++i) {
                        try {
                            testWriter.prepareSStablesToSend((BulkWriterContext)writerContext, new HashSet(existingSSTables));
                            Thread.yield();
                            continue;
                        }
                        catch (IOException e) {
                            String message = e.getMessage();
                            if (message == null || !message.toLowerCase().contains("concurrent")) continue;
                            throw new RuntimeException("Thread safety violation detected", e);
                        }
                    }
                }
                finally {
                    completionLatch.countDown();
                }
            });
            Future<?> closeFuture = executor.submit(() -> {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                try {
                    Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
                    testWriter.close((BulkWriterContext)writerContext);
                }
                catch (Exception e) {
                    throw new RuntimeException("close failed", e);
                }
                finally {
                    completionLatch.countDown();
                }
            });
            startLatch.countDown();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)completionLatch.await(30L, TimeUnit.SECONDS)).as("Both operations should complete within timeout", new Object[0])).isTrue();
            prepareFuture.get(5L, TimeUnit.SECONDS);
            closeFuture.get(5L, TimeUnit.SECONDS);
            Assertions.assertThat((int)testWriter.sstableCount()).isEqualTo(2);
            Assertions.assertThat((long)testWriter.bytesWritten()).isGreaterThan(0L);
            Assertions.assertThat((Map)testWriter.fileDigestMap()).isNotEmpty();
            testWriter.validateSSTables((BulkWriterContext)writerContext);
        }
        finally {
            executor.shutdown();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).as("Executor should terminate cleanly", new Object[0])).isTrue();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testBytesWrittenWithDeletedFiles(String version) throws Exception {
        MockBulkWriterContext writerContext = new MockBulkWriterContext(this.tokenRangeMapping, version, ConsistencyLevel.CL.LOCAL_QUORUM);
        List<SSTableDescriptor> existingSSTables = this.mockSSTableProduced(writerContext);
        ((ListAssert)Assertions.assertThat(existingSSTables).as("Should have produced SSTables", new Object[0])).isNotEmpty();
        SortedSSTableWriter writer = new SortedSSTableWriter((BulkWriterContext)writerContext, this.tmpDir, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        writer.setSSTablesProducedListener(x -> {});
        writer.addRow(BigInteger.valueOf(100L), (Map)ImmutableMap.of((Object)"id", (Object)2, (Object)"date", (Object)2, (Object)"course", (Object)"test2", (Object)"marks", (Object)200));
        Map processedFiles = writer.prepareSStablesToSend((BulkWriterContext)writerContext, new HashSet<SSTableDescriptor>(existingSSTables));
        ((MapAssert)Assertions.assertThat((Map)processedFiles).as("Should have processed existing SSTables", new Object[0])).isNotEmpty();
        long bytesAfterPrepare = writer.bytesWritten();
        for (Path path : processedFiles.keySet()) {
            Files.deleteIfExists(path);
        }
        Assertions.assertThatNoException().isThrownBy(() -> writer.close((BulkWriterContext)writerContext));
        ((AbstractLongAssert)Assertions.assertThat((long)writer.bytesWritten()).as("bytesWritten should have increased after close", new Object[0])).isGreaterThanOrEqualTo(bytesAfterPrepare);
        ((AbstractIntegerAssert)Assertions.assertThat((int)writer.sstableCount()).as("Should have correct sstable count", new Object[0])).isEqualTo(2);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedVersions"})
    public void testPrepareSStablesToSendAfterClose(String version) throws Exception {
        MockBulkWriterContext writerContext = new MockBulkWriterContext(this.tokenRangeMapping, version, ConsistencyLevel.CL.LOCAL_QUORUM);
        SortedSSTableWriter writer = new SortedSSTableWriter((BulkWriterContext)writerContext, this.tmpDir, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        writer.setSSTablesProducedListener(x -> {});
        writer.addRow(BigInteger.valueOf(100L), (Map)ImmutableMap.of((Object)"id", (Object)2, (Object)"date", (Object)2, (Object)"course", (Object)"test2", (Object)"marks", (Object)200));
        writer.close((BulkWriterContext)writerContext);
        int sstableCountAfterClose = writer.sstableCount();
        long bytesWrittenAfterClose = writer.bytesWritten();
        int fileDigestCountAfterClose = writer.fileDigestMap().size();
        Map result = writer.prepareSStablesToSend((BulkWriterContext)writerContext, new HashSet());
        ((MapAssert)Assertions.assertThat((Map)result).as("prepareSStablesToSend should return empty map when called after close", new Object[0])).isEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat((int)writer.sstableCount()).as("sstableCount should not change when prepareSStablesToSend is called after close", new Object[0])).isEqualTo(sstableCountAfterClose);
        ((AbstractLongAssert)Assertions.assertThat((long)writer.bytesWritten()).as("bytesWritten should not change when prepareSStablesToSend is called after close", new Object[0])).isEqualTo(bytesWrittenAfterClose);
        ((AbstractIntegerAssert)Assertions.assertThat((int)writer.fileDigestMap().size()).as("fileDigestMap size should not change when prepareSStablesToSend is called after close", new Object[0])).isEqualTo(fileDigestCountAfterClose);
    }

    private List<SSTableDescriptor> mockSSTableProduced(MockBulkWriterContext writerContext) throws IOException {
        SortedSSTableWriter initialWriter = new SortedSSTableWriter((BulkWriterContext)writerContext, this.tmpDir, (DigestAlgorithm)new XXHash32DigestAlgorithm(), 1);
        ArrayList<SSTableDescriptor> producedSSTables = new ArrayList<SSTableDescriptor>();
        initialWriter.setSSTablesProducedListener(producedSSTables::addAll);
        initialWriter.addRow(BigInteger.ONE, (Map)ImmutableMap.of((Object)"id", (Object)1, (Object)"date", (Object)1, (Object)"course", (Object)"test1", (Object)"marks", (Object)100));
        initialWriter.close((BulkWriterContext)writerContext);
        return producedSSTables;
    }
}

