/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);
    private static final int HASH_BUFFER_SIZE = 524288;

    private IOUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static long zip(Path sourcePath, Path targetPath) throws IOException {
        return IOUtils.zip(sourcePath, targetPath, 1);
    }

    public static long zip(Path sourcePath, Path targetPath, int maxDepth) throws IOException {
        if (!Files.isDirectory(sourcePath, new LinkOption[0])) {
            throw new IOException("Not a directory. sourcePath: " + String.valueOf(sourcePath));
        }
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
             Stream<Path> stream = Files.walk(sourcePath, maxDepth, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourcePath.relativize((Path)path).toString());
                try {
                    zos.putNextEntry(zipEntry);
                    Files.copy(path, zos);
                    zos.closeEntry();
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected error while zipping SSTable components, path = {} not zipped, ", path, (Object)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return targetPath.toFile().length();
    }

    public static String xxhash32(Path path, int bufferSize) throws IOException {
        XXHashFactory factory = XXHashFactory.safeInstance();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            String string;
            block13: {
                StreamingXXHash32 hasher = factory.newStreamingHash32(0);
                try {
                    int len;
                    byte[] buffer = new byte[bufferSize];
                    while ((len = inputStream.read(buffer)) != -1) {
                        hasher.update(buffer, 0, len);
                    }
                    string = Integer.toHexString(hasher.getValue());
                    if (hasher == null) break block13;
                }
                catch (Throwable throwable) {
                    if (hasher != null) {
                        try {
                            hasher.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hasher.close();
            }
            return string;
        }
    }

    public static String xxhash32(Path path) throws IOException {
        return IOUtils.xxhash32(path, 524288);
    }
}

