/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SbwJavaSerializer
extends Serializer {
    public void write(Kryo kryo, Output output, Object object) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectOutputStream objectStream = (ObjectOutputStream)graphContext.get((Object)this);
            if (objectStream == null) {
                objectStream = new ObjectOutputStream((OutputStream)output);
                graphContext.put((Object)this, (Object)objectStream);
            }
            objectStream.writeObject(object);
            objectStream.flush();
        }
        catch (Exception exception) {
            throw new KryoException("Error during Java serialization.", (Throwable)exception);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectInputStream objectStream = (ObjectInputStream)graphContext.get((Object)this);
            if (objectStream == null) {
                objectStream = new ObjectInputStreamWithKryoClassLoader((InputStream)input, kryo);
                graphContext.put((Object)this, (Object)objectStream);
            }
            return objectStream.readObject();
        }
        catch (Exception exception) {
            throw new KryoException("Error during Java deserialization.", (Throwable)exception);
        }
    }

    private static class ObjectInputStreamWithKryoClassLoader
    extends ObjectInputStream {
        private final ClassLoader loader;

        ObjectInputStreamWithKryoClassLoader(InputStream in, Kryo kryo) throws IOException {
            super(in);
            this.loader = kryo.getClassLoader();
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) {
            try {
                return Class.forName(desc.getName(), false, this.loader);
            }
            catch (ClassNotFoundException exception) {
                throw new RuntimeException("Class not found: " + desc.getName(), exception);
            }
        }
    }
}

