/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.reader.EmptyStreamScanner;
import org.apache.cassandra.spark.reader.IndexEntry;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.NoMatchFoundException;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataLayer
implements Serializable {
    public static final long serialVersionUID = 42L;

    public StructType partitionSizeStructType() {
        StructType structType = new StructType();
        for (CqlField field : this.cqlTable().partitionKeys()) {
            MetadataBuilder metadata = this.fieldMetaData(field);
            structType = structType.add(field.name(), this.typeConverter().sparkSqlType(field, this.bigNumberConfig(field)), true, metadata.build());
        }
        structType = structType.add("uncompressed", DataTypes.LongType);
        structType = structType.add("compressed", DataTypes.LongType);
        return structType;
    }

    public StructType structType() {
        StructType structType = new StructType();
        for (CqlField field : this.cqlTable().fields()) {
            MetadataBuilder metadata = this.fieldMetaData(field);
            structType = structType.add(field.name(), this.typeConverter().sparkSqlType(field, this.bigNumberConfig(field)), true, metadata.build());
        }
        for (SchemaFeature feature : this.requestedFeatures()) {
            feature.generateDataType(this.cqlTable(), structType);
            structType = structType.add(feature.field());
        }
        return structType;
    }

    private MetadataBuilder fieldMetaData(CqlField field) {
        MetadataBuilder metadata = new MetadataBuilder();
        metadata.putLong("position", (long)field.position());
        metadata.putString("cqlType", field.cqlTypeName());
        metadata.putBoolean("isPartitionKey", field.isPartitionKey());
        metadata.putBoolean("isPrimaryKey", field.isPrimaryKey());
        metadata.putBoolean("isClusteringKey", field.isClusteringColumn());
        metadata.putBoolean("isStaticColumn", field.isStaticColumn());
        metadata.putBoolean("isValueColumn", field.isValueColumn());
        return metadata;
    }

    public List<SchemaFeature> requestedFeatures() {
        return Collections.emptyList();
    }

    public BigNumberConfig bigNumberConfig(CqlField field) {
        return BigNumberConfig.DEFAULT;
    }

    public CassandraVersion version() {
        return this.bridge().getVersion();
    }

    public abstract CassandraBridge bridge();

    public SparkSqlTypeConverter typeConverter() {
        return CassandraBridgeFactory.getSparkSql(this.version());
    }

    public abstract int partitionCount();

    public abstract CqlTable cqlTable();

    public abstract boolean isInPartition(int var1, BigInteger var2, ByteBuffer var3);

    public abstract TimeProvider timeProvider();

    public List<PartitionKeyFilter> partitionKeyFiltersInRange(int partitionId, List<PartitionKeyFilter> partitionKeyFilters) throws NoMatchFoundException {
        return partitionKeyFilters;
    }

    public SparkRangeFilter sparkRangeFilter(int partitionId) {
        return null;
    }

    @NotNull
    public SSTableTimeRangeFilter sstableTimeRangeFilter() {
        return SSTableTimeRangeFilter.ALL;
    }

    protected abstract ExecutorService executorService();

    public abstract SSTablesSupplier sstables(int var1, @Nullable SparkRangeFilter var2, @NotNull List<PartitionKeyFilter> var3);

    public abstract Partitioner partitioner();

    public abstract String jobId();

    public StreamScanner openCompactionScanner(int partitionId, List<PartitionKeyFilter> partitionKeyFilters, SSTableTimeRangeFilter sstableTimeRangeFilter) {
        return this.openCompactionScanner(partitionId, partitionKeyFilters, sstableTimeRangeFilter, null);
    }

    public boolean readIndexOffset() {
        return true;
    }

    public boolean useIncrementalRepair() {
        return true;
    }

    public StreamScanner<RowData> openCompactionScanner(int partitionId, List<PartitionKeyFilter> partitionKeyFilters, SSTableTimeRangeFilter sstableTimeRangeFilter, @Nullable PruneColumnFilter columnFilter) {
        List<PartitionKeyFilter> filtersInRange;
        try {
            filtersInRange = this.partitionKeyFiltersInRange(partitionId, partitionKeyFilters);
        }
        catch (NoMatchFoundException exception) {
            return EmptyStreamScanner.INSTANCE;
        }
        SparkRangeFilter sparkRangeFilter = this.sparkRangeFilter(partitionId);
        return this.bridge().getCompactionScanner(this.cqlTable(), this.partitioner(), this.sstables(partitionId, sparkRangeFilter, filtersInRange), sparkRangeFilter, filtersInRange, sstableTimeRangeFilter, columnFilter, this.timeProvider(), this.readIndexOffset(), this.useIncrementalRepair(), this.stats());
    }

    public StreamScanner<IndexEntry> openPartitionSizeIterator(int partitionId) {
        SparkRangeFilter rangeFilter = this.sparkRangeFilter(partitionId);
        return this.bridge().getPartitionSizeIterator(this.cqlTable(), this.partitioner(), this.sstables(partitionId, rangeFilter, Collections.emptyList()), rangeFilter, this.timeProvider(), this.stats(), this.executorService());
    }

    public Filter[] unsupportedPushDownFilters(Filter[] filters) {
        Set partitionKeys = this.cqlTable().partitionKeys().stream().map(key -> StringUtils.lowerCase((String)key.name())).collect(Collectors.toSet());
        ArrayList<Filter> unsupportedFilters = new ArrayList<Filter>(filters.length);
        for (Filter filter : filters) {
            if (filter instanceof EqualTo || filter instanceof In) {
                String columnName = StringUtils.lowerCase((String)(filter instanceof EqualTo ? ((EqualTo)filter).attribute() : ((In)filter).attribute()));
                if (partitionKeys.contains(columnName)) {
                    partitionKeys.remove(columnName);
                    continue;
                }
                unsupportedFilters.add(filter);
                continue;
            }
            unsupportedFilters.add(filter);
        }
        return partitionKeys.size() > 0 ? filters : unsupportedFilters.toArray(new Filter[0]);
    }

    public Stats stats() {
        return Stats.DoNothingStats.INSTANCE;
    }
}

