/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.BitmapContainerCharIterator;
import org.roaringbitmap.PeekableCharRankIterator;

final class BitmapContainerCharRankIterator
extends BitmapContainerCharIterator
implements PeekableCharRankIterator {
    private int nextRank = 1;

    BitmapContainerCharRankIterator(long[] p) {
        super(p);
    }

    @Override
    public int peekNextRank() {
        return this.nextRank;
    }

    @Override
    public char next() {
        ++this.nextRank;
        return super.next();
    }

    @Override
    public void advanceIfNeeded(char minval) {
        if (!this.hasNext()) {
            return;
        }
        if (minval >= this.x * 64) {
            if (minval >= (this.x + 1) * 64) {
                int nextX = minval / 64;
                this.nextRank += Long.bitCount(this.w);
                ++this.x;
                while (this.x < nextX) {
                    this.w = this.bitmap[this.x];
                    this.nextRank += Long.bitCount(this.w);
                    ++this.x;
                }
                this.w = this.bitmap[nextX];
            }
            this.nextRank += Long.bitCount(this.w);
            this.w &= -1L << (minval & 0x3F);
            this.nextRank -= Long.bitCount(this.w);
            while (this.w == 0L) {
                ++this.x;
                if (!this.hasNext()) {
                    return;
                }
                this.w = this.bitmap[this.x];
            }
        }
    }

    @Override
    public PeekableCharRankIterator clone() {
        return (PeekableCharRankIterator)super.clone();
    }
}

