/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import jakarta.mail.util.FactoryFinder;
import jakarta.mail.util.LineInputStream;
import jakarta.mail.util.LineOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public interface StreamProvider {
    public InputStream inputBase64(InputStream var1);

    public OutputStream outputBase64(OutputStream var1);

    public InputStream inputBinary(InputStream var1);

    public OutputStream outputBinary(OutputStream var1);

    public OutputStream outputB(OutputStream var1);

    public InputStream inputQ(InputStream var1);

    public OutputStream outputQ(OutputStream var1, boolean var2);

    public LineInputStream inputLineStream(InputStream var1, boolean var2);

    public LineOutputStream outputLineStream(OutputStream var1, boolean var2);

    public InputStream inputQP(InputStream var1);

    public OutputStream outputQP(OutputStream var1);

    public InputStream inputSharedByteArray(byte[] var1);

    public InputStream inputUU(InputStream var1);

    public OutputStream outputUU(OutputStream var1, String var2);

    public static StreamProvider provider() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<StreamProvider>(){

                @Override
                public StreamProvider run() {
                    return FactoryFinder.find(StreamProvider.class);
                }
            });
        }
        return FactoryFinder.find(StreamProvider.class);
    }

    public static enum EncoderTypes {
        BASE_64("base64"),
        B_ENCODER("b"),
        Q_ENCODER("q"),
        BINARY_ENCODER("binary"),
        BIT7_ENCODER("7bit"),
        BIT8_ENCODER("8bit"),
        QUOTED_PRINTABLE_ENCODER("quoted-printable"),
        UU_ENCODER("uuencode"),
        X_UU_ENCODER("x-uuencode"),
        X_UUE("x-uue");

        private final String encoder;

        private EncoderTypes(String encoder) {
            this.encoder = encoder;
        }

        public String getEncoder() {
            return this.encoder;
        }
    }
}

