/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.TrustedNamesCriterion;

public class StaticPKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    @Nonnull
    private final List<PKIXValidationInformation> pkixInfo;
    @Nonnull
    private final Set<String> trustedNames;
    private boolean supportDynamicTrustedNames;

    public StaticPKIXValidationInformationResolver(@Nullable @ParameterName(name="info") List<PKIXValidationInformation> info, @Nullable @ParameterName(name="names") Set<String> names) {
        this(info, names, false);
    }

    public StaticPKIXValidationInformationResolver(@Nullable @ParameterName(name="info") List<PKIXValidationInformation> info, @Nullable @ParameterName(name="names") Set<String> names, @ParameterName(name="supportDynamicNames") boolean supportDynamicNames) {
        this.pkixInfo = info != null ? CollectionSupport.copyToList(info) : CollectionSupport.emptyList();
        this.trustedNames = names != null ? CollectionSupport.copyToSet(names) : CollectionSupport.emptySet();
        this.supportDynamicTrustedNames = supportDynamicNames;
    }

    @Nonnull
    public Set<String> resolveTrustedNames(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        TrustedNamesCriterion trustedNamesCriterion;
        if (criteriaSet == null) {
            return CollectionSupport.copyToSet(this.trustedNames);
        }
        HashSet<String> temp = new HashSet<String>(this.trustedNames);
        EntityIdCriterion entityIDCriterion = (EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class);
        if (entityIDCriterion != null) {
            temp.add(entityIDCriterion.getEntityId());
        }
        if (this.supportDynamicTrustedNames && (trustedNamesCriterion = (TrustedNamesCriterion)criteriaSet.get(TrustedNamesCriterion.class)) != null) {
            temp.addAll(trustedNamesCriterion.getTrustedNames());
        }
        return CollectionSupport.copyToSet(temp);
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    @Nonnull
    public Iterable<PKIXValidationInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.pkixInfo;
    }

    @Nullable
    public PKIXValidationInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        if (!this.pkixInfo.isEmpty()) {
            return this.pkixInfo.get(0);
        }
        return null;
    }
}

