/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SplittingBufferSource
implements BufferSource {
    private final ByteBuffer base;
    private final Stack[] cascade;
    public static final int HEADERSZ = 8;
    private final int lowerbound;
    private long timeout = 200L;

    public SplittingBufferSource(int min, int max, long timeout) {
        this(min, max);
        this.timeout = timeout;
    }

    public SplittingBufferSource(int min, int size) {
        if (size > 0x70000000 || size < 0) {
            size = 0x70000000;
        }
        this.lowerbound = Integer.numberOfLeadingZeros(min);
        int spread = this.lowerbound - Integer.numberOfLeadingZeros(size) + 1;
        if (Integer.numberOfTrailingZeros(size) < spread) {
            size |= 1 << spread;
            size &= -1 << spread;
        }
        ByteBuffer create = null;
        while (create == null) {
            try {
                create = ByteBuffer.allocateDirect(size);
            }
            catch (OutOfMemoryError oome) {
                if (spread < 5) {
                    throw oome;
                }
                spread = this.lowerbound - Integer.numberOfLeadingZeros(size >>= 1) + 1;
            }
        }
        this.base = create;
        this.cascade = new Stack[spread];
        for (int x = 0; x < this.cascade.length; ++x) {
            this.cascade[x] = new Stack(x);
        }
        this.cascade[0].push(this.base.duplicate());
    }

    @Override
    public ByteBuffer getBuffer(int size) {
        ByteBuffer header = null;
        if (size > this.base.capacity()) {
            return null;
        }
        int slot = this.cascade.length - (this.lowerbound - Integer.numberOfLeadingZeros(size + 8) + 2);
        while (header == null) {
            try {
                header = this.split(slot);
            }
            catch (OutOfMemoryError err) {
                header = this.pauseForMore(slot);
                if (header != null || (header = this.consolidate(slot)) != null || (header = this.pauseForMore(slot)) != null) continue;
                this.reclaim();
                return null;
            }
        }
        header.clear();
        try {
            header.limit(size + 8).position(8);
        }
        catch (IllegalArgumentException ia) {
            return null;
        }
        return header;
    }

    private ByteBuffer pauseForMore(int slot) {
        if (slot >= this.cascade.length) {
            slot = this.cascade.length - 1;
        }
        if (this.timeout > 0L) {
            return this.cascade[slot].pauseForMore(this.timeout);
        }
        return null;
    }

    private ByteBuffer consolidate(int slot) {
        if (slot >= this.cascade.length) {
            return null;
        }
        ByteBuffer roll = this.cascade[slot].reclaim();
        if (roll == null) {
            roll = this.cascade[slot].reclaim(this.consolidate(slot + 1));
        }
        if (roll == null) {
            roll = this.cascade[slot].reclaim();
        }
        return roll;
    }

    private ByteBuffer split(int slot) throws OutOfMemoryError {
        if (slot >= this.cascade.length) {
            slot = this.cascade.length - 1;
        } else if (slot < 0) {
            throw new OutOfMemoryError("OOME");
        }
        ByteBuffer split = this.cascade[slot].lazyPop();
        if (split == null) {
            split = this.cascade[slot].pop();
        }
        if (split == null) {
            split = this.split(slot - 1);
            int order = split.getInt(4);
            int address = split.getInt(0);
            split.clear().limit(this.cascade[slot].blocksz);
            this.cascade[slot].push(split.slice());
            split.position(this.cascade[slot].blocksz).limit(this.cascade[slot].blocksz * 2);
            split = split.slice();
            split.putInt(4, order | 1 << slot - 1);
            split.putInt(0, address + this.cascade[slot].blocksz);
        }
        return split;
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        this.returnBufferToSlot(buffer, true);
    }

    private void returnBufferToSlot(ByteBuffer buffer, boolean lazy) {
        if (buffer.getInt(4) == Integer.MIN_VALUE) {
            return;
        }
        int slot = this.cascade.length - (this.lowerbound - Integer.numberOfLeadingZeros(buffer.capacity()) + 1);
        if (lazy) {
            this.cascade[slot].lazyPush(buffer);
        } else {
            this.cascade[slot].push(buffer);
        }
    }

    public String toString() {
        ArrayList<String> cas = new ArrayList<String>(this.cascade.length);
        int size = 0;
        for (Stack s : this.cascade) {
            cas.add(s.toString());
            size += s.capacity();
        }
        return "SplittingBufferSource{base=" + this.base + ", cascade=" + cas + ", size=" + this.base.capacity() + ", total=" + size + "}";
    }

    @Override
    public void reclaim() {
        for (int x = this.cascade.length - 1; x > 0; --x) {
            ByteBuffer b = this.cascade[x].reclaim();
            while (b != null) {
                this.cascade[x - 1].push(b);
                b = this.cascade[x].reclaim();
            }
        }
    }

    int usage() {
        return this.base.capacity();
    }

    int available() {
        int size = 0;
        for (Stack s : this.cascade) {
            size += s.capacity();
        }
        return size;
    }

    int largestChunk() {
        for (Stack s : this.cascade) {
            if (s.pointer <= 0 && s.lazy.isEmpty()) continue;
            return s.blocksz;
        }
        return 0;
    }

    private class Stack {
        private int pointer = 0;
        private int waiting = 0;
        private int max = 0;
        private ByteBuffer[] slots;
        private final int order;
        private final int blocksz;
        private final Queue<ByteBuffer> lazy = new ConcurrentLinkedQueue<ByteBuffer>();

        public Stack(int order) {
            this.slots = new ByteBuffer[1];
            this.order = order;
            this.blocksz = SplittingBufferSource.this.base.capacity() >> order;
        }

        private void lazyLoad() {
            ByteBuffer item = this.lazy.poll();
            while (item != null) {
                this.add(item);
                item = this.lazy.poll();
            }
        }

        ByteBuffer lazyPop() {
            return this.lazy.poll();
        }

        synchronized ByteBuffer pop() {
            if (!this.lazy.isEmpty()) {
                this.lazyLoad();
            }
            if (this.pointer == 0) {
                return null;
            }
            return this.slots[--this.pointer];
        }

        synchronized ByteBuffer reclaim(ByteBuffer bb) {
            ByteBuffer merged;
            if (bb == null) {
                return null;
            }
            if (this.pointer > 0 && (merged = this.consolidate(bb.getInt(4), this.slots[this.pointer - 1].getInt(4))) != null) {
                --this.pointer;
                return merged;
            }
            this.add(bb);
            if (this.waiting > 0) {
                this.notify();
            }
            return null;
        }

        synchronized ByteBuffer pauseForMore(long sleep) {
            this.lazyLoad();
            if (this.pointer == 0) {
                try {
                    ++this.waiting;
                    this.wait(sleep);
                    --this.waiting;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            if (this.pointer > 0) {
                return this.slots[--this.pointer];
            }
            return null;
        }

        private void add(ByteBuffer bb) {
            if (bb.capacity() != this.blocksz) {
                throw new AssertionError((Object)("not returning block to proper stack " + bb.capacity() + " " + this.blocksz));
            }
            if (this.pointer == SplittingBufferSource.this.base.capacity() / this.blocksz) {
                throw new AssertionError((Object)"more returned then allocated");
            }
            if (this.slots.length == this.pointer) {
                this.slots = Arrays.copyOf(this.slots, this.slots.length << 1);
            }
            this.slots[this.pointer++] = bb;
            if (this.max < this.pointer) {
                this.max = this.pointer;
            }
        }

        void lazyPush(ByteBuffer bb) {
            this.lazy.add(bb);
        }

        synchronized void push(ByteBuffer bb) {
            this.add(bb);
            if (this.waiting > 0) {
                this.notify();
            }
        }

        private ByteBuffer consolidate(int ls, int rs) {
            int mask = 1 << this.order - 1;
            if ((ls ^ rs) == mask) {
                int address = ls & ~mask;
                ByteBuffer br = SplittingBufferSource.this.base.duplicate();
                address = this.address(address);
                br.position(address).limit(address + (this.blocksz << 1));
                return br.slice();
            }
            return null;
        }

        synchronized ByteBuffer reclaim() {
            this.lazyLoad();
            if (this.pointer < 2) {
                return null;
            }
            ByteBuffer twin = this.slots[this.pointer - 1];
            int check = twin.getInt(4);
            for (int x = 0; x < this.pointer - 1; ++x) {
                ByteBuffer merged = this.consolidate(check, this.slots[x].getInt(4));
                if (merged == null) continue;
                System.arraycopy(this.slots, x + 1, this.slots, x, this.pointer - x - 2);
                this.pointer -= 2;
                return merged;
            }
            return null;
        }

        private int address(int tag) {
            int rev = Integer.reverse(tag);
            rev >>>= 32 - this.order;
            return rev *= this.blocksz;
        }

        synchronized int capacity() {
            int size = 0;
            for (int x = 0; x < this.pointer; ++x) {
                size += this.slots[x].capacity();
            }
            for (ByteBuffer b : this.lazy) {
                size += b.capacity();
            }
            return size;
        }

        synchronized boolean isEmpty() {
            return this.pointer == 0;
        }

        public String toString() {
            return "Stack{max=" + this.max + ", pointer=" + this.pointer + ", size=" + this.slots.length + ", holding=" + this.capacity() + '}';
        }
    }
}

