/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.util;

import java.util.ArrayList;

public class LongLongOrderedDeltaArray {
    private final int chunkSize;
    private final int shiftAmount;
    private final int indexMask;
    private int count = 0;
    private ArrayList<LongLongRun> runs = new ArrayList();
    private int nextInsertionIndex = 0;
    private long lastKeyAdded = 0L;

    public LongLongOrderedDeltaArray(int chunkSize) {
        int i;
        for (i = 1; i < chunkSize; i <<= 1) {
        }
        this.chunkSize = i;
        this.shiftAmount = Integer.numberOfTrailingZeros(i);
        this.indexMask = i - 1;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    int getShiftAmount() {
        return this.shiftAmount;
    }

    int getIndexMask() {
        return this.indexMask;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.runs.clear();
        this.lastKeyAdded = 0L;
        this.nextInsertionIndex = 0;
        this.count = 0;
    }

    private LongLongRun runFor(int index) {
        return this.runs.get(this.runIndexFor(index));
    }

    private int runIndexFor(int index) {
        return index >>> this.shiftAmount;
    }

    private int indexFor(int index) {
        return index & this.indexMask;
    }

    public void append(long key, long value) {
        if (this.isEmpty()) {
            LongLongRun run = this.addRun();
            run.add(key, value);
            this.lastKeyAdded = key;
            this.nextInsertionIndex = 0;
            this.count = 1;
        } else {
            if (key <= this.lastKeyAdded) {
                throw new IllegalStateException("Markers added out of order; last: " + this.lastKeyAdded + " new: " + key);
            }
            LongLongRun run = this.runs.get(this.nextInsertionIndex);
            if (run.isFull()) {
                run = this.addRun();
                run.add(key, value);
                this.lastKeyAdded = key;
                ++this.nextInsertionIndex;
                ++this.count;
            } else {
                run.add(key, value);
                this.lastKeyAdded = key;
                ++this.count;
            }
        }
    }

    private LongLongRun addRun() {
        LongLongRun ret = new LongLongRun(this.chunkSize);
        this.runs.add(ret);
        return ret;
    }

    public long getKey(int index) {
        return this.runFor(index).getKey(this.indexFor(index));
    }

    public long getValue(int index) {
        return this.runFor(index).getValue(this.indexFor(index));
    }

    public LongLongEntry get(int index) {
        return this.runFor(index).get(this.indexFor(index));
    }

    public void update(int index, long key, long value) {
        if (index == this.count) {
            this.append(key, value);
            return;
        }
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        if (index > 0 && this.getKey(index - 1) >= key) {
            throw new IllegalArgumentException("Invalid ordering on set(): " + key);
        }
        if (index + 1 < this.count && this.getKey(index + 1) <= key) {
            throw new IllegalArgumentException("Invalid ordering on set(): " + key);
        }
        this.runFor(index).set(this.indexFor(index), key, value);
    }

    public int binarySearch(long target) {
        int min = 0;
        int max = this.size() - 1;
        while (max >= min) {
            int mid = min + (max - min) / 2;
            long cmp = target - this.getKey(mid);
            if (cmp == 0L) {
                return mid;
            }
            if (cmp > 0L) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return ~min;
    }

    public static class LongLongEntry {
        private final long key;
        private final long value;

        public LongLongEntry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }
    }

    static class LongLongRun {
        private final int max;
        private final int[] keys;
        private final int[] vals;
        private int count = 0;
        private long baseKey;
        private long baseValue;

        LongLongRun(int max) {
            this.max = max;
            this.keys = new int[max];
            this.vals = new int[max];
        }

        int size() {
            return this.count;
        }

        void add(long key, long value) {
            if (!this.isFull()) {
                long kdiff;
                if (this.count == 0) {
                    this.baseKey = key;
                    this.baseValue = value;
                }
                if ((kdiff = key - this.baseKey) > Integer.MAX_VALUE || kdiff < Integer.MIN_VALUE) {
                    throw new IllegalStateException("Mark value span too large: " + this.baseKey + "/" + key);
                }
                long vdiff = value - this.baseValue;
                if (vdiff > Integer.MAX_VALUE || vdiff < Integer.MIN_VALUE) {
                    throw new IllegalStateException("Start value span too large: " + this.baseValue + "/" + value);
                }
                this.keys[this.count] = (int)kdiff;
                this.vals[this.count] = (int)vdiff;
                ++this.count;
            } else {
                throw new ArrayIndexOutOfBoundsException();
            }
        }

        long getKey(int index) {
            return this.baseKey + (long)this.keys[index];
        }

        long getValue(int index) {
            return this.baseValue + (long)this.vals[index];
        }

        LongLongEntry get(int index) {
            return new LongLongEntry(this.getKey(index), this.getValue(index));
        }

        boolean isFull() {
            return this.count == this.max;
        }

        void set(int index, long key, long value) {
            long kdiff = key - this.baseKey;
            if (kdiff > Integer.MAX_VALUE || kdiff < Integer.MIN_VALUE) {
                throw new IllegalStateException("Key value span too large: " + this.baseKey + "/" + key);
            }
            long vdiff = value - this.baseValue;
            if (vdiff > Integer.MAX_VALUE || vdiff < Integer.MIN_VALUE) {
                throw new IllegalStateException("Value value span too large: " + this.baseValue + "/" + value);
            }
            this.keys[index] = (int)kdiff;
            this.vals[index] = (int)vdiff;
        }
    }
}

