/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.tools.corba.common.XmlSchemaPrimitiveMap;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.Visitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaType;

public class PrimitiveTypesVisitor
implements Visitor {
    private static XmlSchemaPrimitiveMap xmlSchemaPrimitiveMap = new XmlSchemaPrimitiveMap();
    private static final List<Integer> PRIMITIVE_TYPES = new ArrayList<Integer>();
    private XmlSchemaType schemaType;
    private CorbaType corbaType;
    private Scope scope;
    private XmlSchemaCollection schemas;

    public PrimitiveTypesVisitor(Scope scopeRef, Definition defn, XmlSchema schemaRef, XmlSchemaCollection xmlSchemas) {
        this.scope = scopeRef;
        this.schemas = xmlSchemas;
    }

    public static boolean accept(AST node) {
        return PRIMITIVE_TYPES.contains(node.getType());
    }

    @Override
    public void visit(AST node) {
        QName schemaTypeQName;
        XmlSchemaType stype = null;
        CorbaType ctype = null;
        QName corbaTypeQName = PrimitiveTypesVisitor.getPrimitiveType(node);
        if (corbaTypeQName != null && (schemaTypeQName = xmlSchemaPrimitiveMap.get(corbaTypeQName)) != null && (stype = this.schemas.getTypeByQName(schemaTypeQName)) != null) {
            ctype = new CorbaType();
            ctype.setQName(corbaTypeQName);
            ctype.setType(stype.getQName());
            ctype.setName(stype.getQName().getLocalPart());
        }
        this.schemaType = stype;
        this.corbaType = ctype;
    }

    @Override
    public XmlSchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    public CorbaType getCorbaType() {
        return this.corbaType;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Scope getFullyQualifiedName() {
        return this.scope;
    }

    public static QName getPrimitiveType(AST node) {
        QName result = null;
        switch (node.getType()) {
            case 45: {
                if (node.getNextSibling() != null && node.getNextSibling().getType() == 45) {
                    result = CorbaConstants.NT_CORBA_LONGLONG;
                    break;
                }
                if (node.getFirstChild() != null && node.getFirstChild().getType() == 44) {
                    result = CorbaConstants.NT_CORBA_LONGDOUBLE;
                    break;
                }
                result = CorbaConstants.NT_CORBA_LONG;
                break;
            }
            case 47: {
                AST node2 = node.getNextSibling();
                if (node2 != null && node2.getType() == 46) {
                    result = CorbaConstants.NT_CORBA_USHORT;
                    break;
                }
                if (node2 == null || node2.getType() != 45) break;
                AST node3 = node2.getNextSibling();
                if (node3 != null && node3.getType() == 45) {
                    result = CorbaConstants.NT_CORBA_ULONGLONG;
                    break;
                }
                result = CorbaConstants.NT_CORBA_ULONG;
                break;
            }
            case 46: {
                result = CorbaConstants.NT_CORBA_SHORT;
                break;
            }
            case 43: {
                result = CorbaConstants.NT_CORBA_FLOAT;
                break;
            }
            case 44: {
                result = CorbaConstants.NT_CORBA_DOUBLE;
                break;
            }
            case 48: {
                result = CorbaConstants.NT_CORBA_CHAR;
                break;
            }
            case 49: {
                result = CorbaConstants.NT_CORBA_WCHAR;
                break;
            }
            case 63: {
                result = CorbaConstants.NT_CORBA_STRING;
                break;
            }
            case 64: {
                result = CorbaConstants.NT_CORBA_WSTRING;
                break;
            }
            case 50: {
                result = CorbaConstants.NT_CORBA_BOOLEAN;
                break;
            }
            case 51: {
                result = CorbaConstants.NT_CORBA_OCTET;
                break;
            }
            case 52: {
                result = CorbaConstants.NT_CORBA_ANY;
                break;
            }
        }
        return result;
    }

    static {
        PRIMITIVE_TYPES.add(43);
        PRIMITIVE_TYPES.add(44);
        PRIMITIVE_TYPES.add(45);
        PRIMITIVE_TYPES.add(46);
        PRIMITIVE_TYPES.add(47);
        PRIMITIVE_TYPES.add(48);
        PRIMITIVE_TYPES.add(49);
        PRIMITIVE_TYPES.add(50);
        PRIMITIVE_TYPES.add(52);
        PRIMITIVE_TYPES.add(51);
        PRIMITIVE_TYPES.add(52);
    }
}

