/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.JSFunction;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public abstract class NewLiteralStorage {
    protected Object[] keys;
    protected int[] getterSetters;
    protected Object[] values;
    protected int index = 0;
    protected int[] skipIndexes = null;
    protected int[] spreadAdjustments = null;

    protected NewLiteralStorage(Object[] ids, int length, boolean createKeys) {
        int l;
        if (ids != null) {
            this.keys = ids;
            l = ids.length;
        } else {
            this.keys = createKeys ? new Object[length] : null;
            l = length;
        }
        this.getterSetters = new int[l];
        this.values = new Object[l];
    }

    public void pushValue(Object value) {
        this.values[this.index] = value;
        this.attemptToInferFunctionName(value);
        ++this.index;
    }

    public void pushGetter(Object value) {
        this.getterSetters[this.index] = -1;
        this.pushValue(value);
    }

    public void pushSetter(Object value) {
        this.getterSetters[this.index] = 1;
        this.pushValue(value);
    }

    public void pushKey(Object key) {
        this.keys[this.index] = key instanceof Symbol ? key : ScriptRuntime.toString(key);
    }

    public void spread(Context cx, Scriptable scope, Object source, int sourcePosition) {
        int indexBefore = this.index;
        if (this.keys == null) {
            this.spreadArray(cx, scope, source);
        } else {
            this.spreadObject(cx, scope, source);
        }
        if (this.spreadAdjustments != null && sourcePosition < this.spreadAdjustments.length) {
            this.spreadAdjustments[sourcePosition] = this.index - indexBefore - 1;
        }
    }

    private void spreadArray(Context cx, Scriptable scope, Object source) {
        block13: {
            Object iterator;
            if (source == null || Undefined.isUndefined(source)) break block13;
            Scriptable src = ScriptRuntime.toObject(cx, scope, source);
            Object iteratorProp = ScriptableObject.getProperty(src, SymbolKey.ITERATOR);
            if (iteratorProp != Scriptable.NOT_FOUND && !Undefined.isUndefined(iteratorProp) && !Undefined.isUndefined(iterator = ScriptRuntime.callIterator(src, cx, scope))) {
                ArrayList spreadValues = new ArrayList();
                try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
                    for (Object temp : it) {
                        spreadValues.add(temp);
                    }
                }
                int spreadSize = spreadValues.size();
                int newLen = this.values.length + spreadSize;
                this.getterSetters = Arrays.copyOf(this.getterSetters, newLen);
                this.values = Arrays.copyOf(this.values, newLen);
                for (Object value : spreadValues) {
                    this.pushValue(value);
                }
                return;
            }
            int spreadSize = src instanceof NativeArray ? (int)((NativeArray)src).getLength() : src.getIds().length;
            int newLen = this.values.length + spreadSize;
            this.getterSetters = Arrays.copyOf(this.getterSetters, newLen);
            this.values = Arrays.copyOf(this.values, newLen);
            if (src instanceof NativeArray) {
                NativeArray arr = (NativeArray)src;
                long length = arr.getLength();
                int i = 0;
                while ((long)i < length) {
                    Object value = NativeArray.getElem(cx, arr, i);
                    this.pushValue(value);
                    ++i;
                }
            } else {
                Object[] ids;
                for (Object id : ids = src.getIds()) {
                    Object value = this.getPropertyById(src, id);
                    this.pushValue(value);
                }
            }
        }
    }

    private void spreadObject(Context cx, Scriptable scope, Object source) {
        if (source != null && !Undefined.isUndefined(source)) {
            Object[] ids;
            Scriptable src = ScriptRuntime.toObject(cx, scope, source);
            if (src instanceof ScriptableObject) {
                ScriptableObject scriptable = (ScriptableObject)src;
                try (CompoundOperationMap map = scriptable.startCompoundOp(false);){
                    ids = scriptable.getIds(map, false, true);
                }
            } else {
                ids = src.getIds();
            }
            int newLen = this.values.length + ids.length;
            this.keys = Arrays.copyOf(this.keys, newLen);
            this.getterSetters = Arrays.copyOf(this.getterSetters, newLen);
            this.values = Arrays.copyOf(this.values, newLen);
            for (Object id : ids) {
                Object value = this.getPropertyById(src, id);
                this.pushKey(id);
                this.pushValue(value);
            }
        }
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public int[] getGetterSetters() {
        return this.getterSetters;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setSkipIndexes(int[] skipIndexes) {
        this.skipIndexes = skipIndexes;
        if (skipIndexes != null && skipIndexes.length > 0) {
            this.spreadAdjustments = new int[this.values.length + skipIndexes.length];
        }
    }

    public boolean hasSkipIndexes() {
        return this.skipIndexes != null;
    }

    public int[] getAdjustedSkipIndexes() {
        if (this.skipIndexes == null) {
            return null;
        }
        int[] adjusted = new int[this.skipIndexes.length];
        for (int i = 0; i < this.skipIndexes.length; ++i) {
            int sourceSkip = this.skipIndexes[i];
            int adjustment = 0;
            if (this.spreadAdjustments != null) {
                for (int sourcePos = 0; sourcePos < sourceSkip && sourcePos < this.spreadAdjustments.length; ++sourcePos) {
                    adjustment += this.spreadAdjustments[sourcePos];
                }
            }
            adjusted[i] = sourceSkip + adjustment;
        }
        return adjusted;
    }

    private Object getPropertyById(Scriptable src, Object id) {
        if (id instanceof String) {
            return ScriptableObject.getProperty(src, (String)id);
        }
        if (id instanceof Integer) {
            return ScriptableObject.getProperty(src, (Integer)id);
        }
        if (ScriptRuntime.isSymbol(id)) {
            return ScriptableObject.getProperty(src, (Symbol)id);
        }
        throw Kit.codeBug();
    }

    public static NewLiteralStorage create(Context cx, Object[] ids) {
        if (cx.getLanguageVersion() >= 200) {
            return new NameInference(ids, -1, false);
        }
        return new NoInference(ids, -1, false);
    }

    public static NewLiteralStorage create(Context cx, int length, boolean createKeys) {
        if (cx.getLanguageVersion() >= 200) {
            return new NameInference(null, length, createKeys);
        }
        return new NoInference(null, length, createKeys);
    }

    protected abstract void attemptToInferFunctionName(Object var1);

    private static final class NameInference
    extends NewLiteralStorage {
        NameInference(Object[] ids, int length, boolean createKeys) {
            super(ids, length, createKeys);
        }

        @Override
        protected void attemptToInferFunctionName(Object value) {
            if (this.keys == null || !(value instanceof JSFunction)) {
                return;
            }
            BaseFunction fun = (BaseFunction)value;
            if (!"".equals(fun.get("name", (Scriptable)fun))) {
                return;
            }
            String prefix = "";
            if (this.getterSetters[this.index] == -1) {
                prefix = "get ";
            } else if (this.getterSetters[this.index] == 1) {
                prefix = "set ";
            }
            Object propKey = this.keys[this.index];
            if (propKey instanceof Symbol) {
                String symbolName = ((Symbol)propKey).getName();
                if (!symbolName.isEmpty()) {
                    fun.setFunctionName(prefix + "[" + symbolName + "]");
                } else if (!prefix.isEmpty()) {
                    fun.setFunctionName(prefix);
                }
            } else if (!propKey.equals("__proto__")) {
                fun.setFunctionName(prefix + String.valueOf(propKey));
            } else if (fun instanceof JSFunction && ((JSFunction)fun).isShorthand()) {
                fun.setFunctionName(prefix + String.valueOf(propKey));
            }
        }
    }

    private static final class NoInference
    extends NewLiteralStorage {
        NoInference(Object[] ids, int length, boolean createKeys) {
            super(ids, length, createKeys);
        }

        @Override
        protected void attemptToInferFunctionName(Object value) {
        }
    }
}

