/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.udf;

import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.daffodil.api.udf.UserDefinedFunction;
import org.apache.daffodil.api.udf.UserDefinedFunctionIdentification;
import org.apache.daffodil.api.udf.UserDefinedFunctionProvider;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService$EvaluateMethodInfo$;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService$UserDefinedFunctionCallingInfo$;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService$UserDefinedFunctionInfo$;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService$UserDefinedFunctionMethod$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class UserDefinedFunctionService$
implements Serializable {
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(UserDefinedFunctionService$.class.getDeclaredField("currentClassPath$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(UserDefinedFunctionService$.class.getDeclaredField("classUserDefinedFunction$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(UserDefinedFunctionService$.class.getDeclaredField("classUserDefinedFunctionIdentification$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(UserDefinedFunctionService$.class.getDeclaredField("evaluateMethodName$lzy1"));
    private volatile Object evaluateMethodName$lzy1;
    public static final UserDefinedFunctionService$UserDefinedFunctionMethod$ UserDefinedFunctionMethod;
    public static final UserDefinedFunctionService$EvaluateMethodInfo$ EvaluateMethodInfo;
    public static final UserDefinedFunctionService$UserDefinedFunctionCallingInfo$ UserDefinedFunctionCallingInfo;
    public static final UserDefinedFunctionService$UserDefinedFunctionInfo$ UserDefinedFunctionInfo;
    private static final HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup;
    private static final HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache;
    private volatile Object classUserDefinedFunctionIdentification$lzy1;
    private volatile Object classUserDefinedFunction$lzy1;
    private volatile Object currentClassPath$lzy1;
    public static final UserDefinedFunctionService$ MODULE$;

    private UserDefinedFunctionService$() {
    }

    static {
        MODULE$ = new UserDefinedFunctionService$();
        udfInfoLookup = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        initializedUserDefinedFunctionsCache = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        ServiceLoader<UserDefinedFunctionProvider> loader = ServiceLoader.load(UserDefinedFunctionProvider.class);
        Iterator<UserDefinedFunctionProvider> providerIter = loader.iterator();
        while (providerIter.hasNext()) {
            Some some;
            try {
                some = Some$.MODULE$.apply((Object)providerIter.next());
            }
            catch (ServiceConfigurationError e) {
                com.typesafe.scalalogging.Logger LoggerImpl_this;
                com.typesafe.scalalogging.Logger LoggerImpl_this2 = Logger$.MODULE$.log();
                if (LoggerImpl_this2.underlying().isWarnEnabled()) {
                    LoggerImpl_this2.underlying().warn("User Defined Function Provider failed to load: {}. Enable debug logging for more details", (Object)e.getMessage());
                }
                if ((LoggerImpl_this = Logger$.MODULE$.log()).underlying().isDebugEnabled()) {
                    Logger logger = LoggerImpl_this.underlying();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.close();
                    logger.debug(sw.toString());
                }
                some = None$.MODULE$;
            }
            Some providerOpt = some;
            Object[] providerFunctionClasses = (Class[])providerOpt.map((Function1 & Serializable)provider -> {
                Class[] classArray;
                block5: {
                    try {
                        void var2_2;
                        Object object;
                        Object[] functionClasses = provider.getUserDefinedFunctionClasses();
                        if (functionClasses == null || ArrayOps$.MODULE$.isEmpty$extension(object = Predef$.MODULE$.refArrayOps(functionClasses))) {
                            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn("User Defined Function Provider ignored: {}. No User Defined Functions found.", (Object)provider.getClass().getName());
                            }
                            classArray = (Class[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Class.class));
                            break block5;
                        }
                        classArray = var2_2;
                    }
                    catch (Exception e) {
                        com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("User Defined Function Provider ignored: {}. Error loading User Defined Functions: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{provider.getClass().getName(), e}), Object.class));
                        }
                        classArray = (Class[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Class.class));
                    }
                }
                return classArray;
            }).getOrElse(MODULE$::$anonfun$2);
            Object object = Predef$.MODULE$.refArrayOps(providerFunctionClasses);
            Object[] goodFunctionClasses = (Class[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)udfc -> {
                com.typesafe.scalalogging.Logger LoggerImpl_this;
                com.typesafe.scalalogging.Logger LoggerImpl_this2;
                boolean nonUdf;
                boolean nonAnn = !udfc.isAnnotationPresent(this.classUserDefinedFunctionIdentification());
                boolean bl = nonUdf = !this.classUserDefinedFunction().isAssignableFrom((Class<?>)udfc);
                if (nonAnn && (LoggerImpl_this2 = Logger$.MODULE$.log()).underlying().isWarnEnabled()) {
                    LoggerImpl_this2.underlying().warn("User Defined Function ignored: {}. Missing {} annotation", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{udfc.getName(), this.classUserDefinedFunctionIdentification().getName()}), Object.class));
                }
                if (nonUdf && (LoggerImpl_this = Logger$.MODULE$.log()).underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Doesn't implement {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{udfc.getName(), this.classUserDefinedFunction().getName()}), Object.class));
                }
                boolean ret = !nonAnn && !nonUdf;
                return ret;
            });
            Object object2 = Predef$.MODULE$.refArrayOps(goodFunctionClasses);
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)((JProcedure1 & Serializable)arg_0 -> MODULE$.$init$$$anonfun$1((Option)providerOpt, arg_0)));
        }
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UserDefinedFunctionService$.class);
    }

    public String evaluateMethodName() {
        Object object = this.evaluateMethodName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.evaluateMethodName$lzyINIT1();
    }

    private Object evaluateMethodName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.evaluateMethodName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "evaluate";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.evaluateMethodName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification() {
        Object object = this.classUserDefinedFunctionIdentification$lzy1;
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Class)this.classUserDefinedFunctionIdentification$lzyINIT1();
    }

    private Object classUserDefinedFunctionIdentification$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.classUserDefinedFunctionIdentification$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Class<UserDefinedFunctionIdentification> clazz = null;
                    try {
                        clazz = UserDefinedFunctionIdentification.class;
                        object2 = clazz == null ? LazyVals.NullValue$.MODULE$ : clazz;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.classUserDefinedFunctionIdentification$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clazz;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Class<UserDefinedFunction> classUserDefinedFunction() {
        Object object = this.classUserDefinedFunction$lzy1;
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Class)this.classUserDefinedFunction$lzyINIT1();
    }

    private Object classUserDefinedFunction$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.classUserDefinedFunction$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Class<UserDefinedFunction> clazz = null;
                    try {
                        clazz = UserDefinedFunction.class;
                        object2 = clazz == null ? LazyVals.NullValue$.MODULE$ : clazz;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.classUserDefinedFunction$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clazz;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String currentClassPath() {
        Object object = this.currentClassPath$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.currentClassPath$lzyINIT1();
    }

    private Object currentClassPath$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.currentClassPath$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((IterableOnceOps)Misc$.MODULE$.classPath().map((Function1 & Serializable)_$1 -> _$1.toString())).mkString("\n");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.currentClassPath$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo> lookupUserDefinedFunctionCallingInfo(String namespaceURI, String fname) {
        String udfid = "{" + namespaceURI + "}" + fname;
        Option udfFunctionCallingInfo = (Option)initializedUserDefinedFunctionsCache.getOrElse((Object)udfid, () -> UserDefinedFunctionService$.$anonfun$7(udfid, namespaceURI, fname));
        return udfFunctionCallingInfo;
    }

    private final Class[] $anonfun$2() {
        return (Class[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Class.class));
    }

    private final /* synthetic */ void $init$$$anonfun$1(Option providerOpt$1, Class fc) {
        NodeInfo.PrimType primType;
        String fcClassName = fc.getName();
        UserDefinedFunctionIdentification fInfo = fc.getDeclaredAnnotation(this.classUserDefinedFunctionIdentification());
        String fns = fInfo.namespaceURI();
        String fname = fInfo.name();
        Object object = Predef$.MODULE$.refArrayOps((Object[])fc.getMethods());
        Object[] evalMethods = (Method[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> {
            String string = _$2.getName();
            String string2 = this.evaluateMethodName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (Misc$.MODULE$.isNullOrBlank(fns)) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Annotation namespace field is empty or invalid.", (Object)fcClassName);
                return;
            }
            return;
        }
        if (Misc$.MODULE$.isNullOrBlank(fname)) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Annotation name field is empty or invalid.", (Object)fcClassName);
                return;
            }
            return;
        }
        Object object2 = Predef$.MODULE$.refArrayOps(evalMethods);
        if (ArrayOps$.MODULE$.isEmpty$extension(object2)) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Missing evaluate method: {}:{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, fns, fname}), Object.class));
                return;
            }
            return;
        }
        if (evalMethods.length > 1) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Overloaded evaluate method: {}:{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, fns, fname}), Object.class));
                return;
            }
            return;
        }
        Object object3 = Predef$.MODULE$.refArrayOps(evalMethods);
        Method evaluateMethod = (Method)ArrayOps$.MODULE$.head$extension(object3);
        Object[] paramTypes = evaluateMethod.getParameterTypes();
        Class<?> returnType = evaluateMethod.getReturnType();
        Object object4 = Predef$.MODULE$.refArrayOps(paramTypes);
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object4));
        Object[] initParamTypeConv = (Tuple2[])ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class c = (Class)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Option option = (Option)Predef$.MODULE$.ArrowAssoc(NodeInfo$.MODULE$.fromClass(c));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, (Object)BoxesRunTime.boxToInteger((int)i));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Option<NodeInfo.PrimType> initRetTypeConv = NodeInfo$.MODULE$.fromClass(returnType);
        Object object6 = Predef$.MODULE$.refArrayOps(initParamTypeConv);
        Object[] badParams = (String[])ArrayOps$.MODULE$.collect$extension(object6, (PartialFunction)new Serializable((Class[])paramTypes){
            private final Class[] paramTypes$1;
            {
                this.paramTypes$1 = paramTypes$2;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option t = (Option)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (t.isEmpty()) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option t = (Option)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (t.isEmpty()) {
                        Class cn = this.paramTypes$1[i];
                        return cn.getSimpleName();
                    }
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        Object object7 = Predef$.MODULE$.refArrayOps(badParams);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object7)) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Unsupported parameter type(s): {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, Predef$.MODULE$.wrapRefArray(badParams).mkString(",")}), Object.class));
                return;
            }
            return;
        }
        if (initRetTypeConv.isEmpty()) {
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Unsupported return type: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, returnType.getSimpleName()}), Object.class));
                return;
            }
            return;
        }
        Object object8 = Predef$.MODULE$.refArrayOps(initParamTypeConv);
        List evaluateParamTypes = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object8, (Function1 & Serializable)_$3 -> (Option)_$3._1(), ClassTag$.MODULE$.apply(NodeInfo.PrimType.class))).toList();
        Option<NodeInfo.PrimType> option = initRetTypeConv;
        if (!(option instanceof Some) || (primType = (NodeInfo.PrimType)((Some)option).value()) == null) {
            Option<NodeInfo.PrimType> x = option;
            throw Assert$.MODULE$.invariantFailed("Expected Some, found " + x);
        }
        NodeInfo.PrimType evt = primType;
        NodeInfo.PrimType evaluateReturnType = evt;
        String key = "{" + fns + "}" + fname;
        if (udfInfoLookup.contains((Object)key)) {
            UserDefinedFunctionService.UserDefinedFunctionInfo udfInfo = (UserDefinedFunctionService.UserDefinedFunctionInfo)udfInfoLookup.apply((Object)key);
            com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("User Defined Function ignored: {}. Duplicate {} from {} found.", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, key, udfInfo.udfClass().getName()}), Object.class));
                return;
            }
            return;
        }
        UserDefinedFunctionService.UserDefinedFunctionMethod serializableEvaluate = UserDefinedFunctionService$UserDefinedFunctionMethod$.MODULE$.apply(evaluateMethod.getDeclaringClass(), this.evaluateMethodName(), (Class<?>[])paramTypes);
        UserDefinedFunctionService.EvaluateMethodInfo emi = UserDefinedFunctionService$EvaluateMethodInfo$.MODULE$.apply(serializableEvaluate, (List<NodeInfo.Kind>)evaluateParamTypes, evaluateReturnType);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        udfInfoLookup.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)UserDefinedFunctionService$UserDefinedFunctionInfo$.MODULE$.apply(fc, (UserDefinedFunctionProvider)providerOpt$1.get(), emi)));
        com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("User Defined Function loaded: {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fcClassName, key}), Object.class));
            return;
        }
    }

    private static final Option $anonfun$7(String udfid$1, String namespaceURI$1, String fname$1) {
        Option maybeUdfInfo = udfInfoLookup.get((Object)udfid$1);
        return maybeUdfInfo.flatMap((Function1 & Serializable)udfInfo -> {
            None$ none$;
            try {
                UserDefinedFunction udf2 = udfInfo.provider().createUserDefinedFunction(namespaceURI$1, fname$1);
                try {
                    new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(udf2);
                    none$ = Option$.MODULE$.apply((Object)udf2);
                }
                catch (NotSerializableException e) {
                    com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("User Defined Function is not serializable: {}. Could not serialize member of class: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{udf2.getClass().getName(), e.getMessage()}), Object.class));
                    }
                    none$ = None$.MODULE$;
                }
            }
            catch (Exception e) {
                Throwable throwable;
                Exception exception = e;
                if (exception instanceof ReflectiveOperationException) {
                    throwable = e.getCause();
                } else {
                    Exception x = exception;
                    throwable = x;
                }
                Throwable actualCause = throwable;
                throw new UserDefinedFunctionFatalErrorException("User Defined Function could not be initialized: " + udfid$1, actualCause, udfInfo.udfClass().getName(), udfInfo.provider().getClass().getName());
            }
            None$ maybeUdf = none$;
            return maybeUdf.flatMap((Function1 & Serializable)udf -> {
                Class<?> actualUdfClass;
                Class<?> expectedUdfClass = udfInfo.udfClass();
                Class<?> clazz = actualUdfClass = udf.getClass();
                Class<?> clazz2 = expectedUdfClass;
                if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                    com.typesafe.scalalogging.Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("User Defined Function class mismatch: {}. Expected: {} Actual: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{udfid$1, expectedUdfClass, actualUdfClass}), Object.class));
                    }
                    return None$.MODULE$;
                }
                UserDefinedFunctionService.EvaluateMethodInfo udfInfoEval = udfInfo.evaluateMethodInfo();
                udfInfoEval.evaluateMethod().method();
                Some udfci = Some$.MODULE$.apply((Object)UserDefinedFunctionService$UserDefinedFunctionCallingInfo$.MODULE$.apply((UserDefinedFunction)udf, udfInfo.evaluateMethodInfo()));
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)udfid$1);
                initializedUserDefinedFunctionsCache.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)udfci));
                return udfci;
            });
        });
    }
}

