<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [19.0.0](https://github.com/apache/datafusion/tree/19.0.0) (2023-02-24)

[Full Changelog](https://github.com/apache/datafusion/compare/18.0.0...19.0.0)

**Breaking changes:**

- Use DataFusionError instead of ArrowError in SendableRecordBatchStream [\#5101](https://github.com/apache/datafusion/pull/5101) ([comphead](https://github.com/comphead))
- Update to arrow 32 and Switch to RawDecoder for JSON [\#5056](https://github.com/apache/datafusion/pull/5056) [[sql](https://github.com/apache/datafusion/labels/sql)] ([tustvold](https://github.com/tustvold))
- Allow `SessionContext::read_csv`, etc to read multiple files [\#4908](https://github.com/apache/datafusion/pull/4908) ([saikrishna1-bidgely](https://github.com/saikrishna1-bidgely))

**Implemented enhancements:**

- Ignore Arrow in dependabot [\#5340](https://github.com/apache/datafusion/issues/5340)
- Provide access to internal fields of SessionContext [\#5317](https://github.com/apache/datafusion/issues/5317)
- Investigate performance drop for DISTINCT queries [\#5313](https://github.com/apache/datafusion/issues/5313)
- \[DOC\] Update math expression documentation [\#5312](https://github.com/apache/datafusion/issues/5312)
- Replace merge_batches with concat_batches [\#5297](https://github.com/apache/datafusion/issues/5297)
- Support for some of the window frame range queries [\#5275](https://github.com/apache/datafusion/issues/5275)
- Make `log` function to be in sync with PostgresSql [\#5259](https://github.com/apache/datafusion/issues/5259)
- \[SQLLogicTest\] Make schema validation ignore nullable and metadata attributes [\#5231](https://github.com/apache/datafusion/issues/5231)
- Add support for linear groups search [\#5213](https://github.com/apache/datafusion/issues/5213)
- Add SQL function overload `LOG(base, x)` for logarithm of x to base [\#5206](https://github.com/apache/datafusion/issues/5206)
- `all_schema()` will get schema of child of child of .... [\#5192](https://github.com/apache/datafusion/issues/5192)
- Enable parquet parallel scans by default [\#5125](https://github.com/apache/datafusion/issues/5125)
- Don't repartition ProjectionExec when it does not compute anything [\#4968](https://github.com/apache/datafusion/issues/4968)
- Support non-tuple expression for Exists Subquery to Join [\#4934](https://github.com/apache/datafusion/issues/4934)
- Read multiple files/folders using `read_csv` [\#4909](https://github.com/apache/datafusion/issues/4909)

**Fixed bugs:**

- Make inline_table_scan optimize whole plan during first optimization stage. [\#5364](https://github.com/apache/datafusion/issues/5364)
- tpcds_logical_q8 ambiguous name. [\#5334](https://github.com/apache/datafusion/issues/5334)
- Protobuf serialisation is missing for GetIndexedFieldExpr [\#5323](https://github.com/apache/datafusion/issues/5323)
- Indexing a nested list with 0 or an index larger than list size is not handled correctly [\#5310](https://github.com/apache/datafusion/issues/5310)
- Protobuf serialization drops `preserve_partitioning` from `SortExec` [\#5305](https://github.com/apache/datafusion/issues/5305)
- data file without suffix can't be read correctly [\#5301](https://github.com/apache/datafusion/issues/5301)
- Idk [\#5298](https://github.com/apache/datafusion/issues/5298)
- Error with query that has DISTINCT with ORDER BY and aliased select list [\#5293](https://github.com/apache/datafusion/issues/5293)
- Optimizer prunes UnnestExec on aggregate count [\#5281](https://github.com/apache/datafusion/issues/5281)
- Strange Behaviour on RepartitionExec with CoalescePartitionsExec. [\#5278](https://github.com/apache/datafusion/issues/5278)
- Error "For SELECT DISTINCT, ORDER BY expressions id must appear in select list" may be over eager [\#5255](https://github.com/apache/datafusion/issues/5255)
- SQL allows SORT BY keyword [\#5247](https://github.com/apache/datafusion/issues/5247)
- test `sort_on_window_null_string` failed after disable `skip_fail`. [\#5233](https://github.com/apache/datafusion/issues/5233)
- Dataframe API adds ?table? qualifier [\#5187](https://github.com/apache/datafusion/issues/5187)
- Re-ordering Projections in scan are not working anymore \(since DF15\) [\#5146](https://github.com/apache/datafusion/issues/5146)
- parquet page level skipping \(page index pruning\) doesn't work with evolved schemas [\#5104](https://github.com/apache/datafusion/issues/5104)
- Incorrect results on queries with `distinct` and orderby [\#5065](https://github.com/apache/datafusion/issues/5065)
- NestedLoopJoin will panic when right child contains RepartitionExec [\#5022](https://github.com/apache/datafusion/issues/5022)
- JSON projection only work when the index is in ascending order [\#4832](https://github.com/apache/datafusion/issues/4832)
- Stack overflows when planning tpcds 22 in debug mode [\#4786](https://github.com/apache/datafusion/issues/4786)
- Failed to create Left anti join physical plan due to SchemaError::FieldNotFound [\#4366](https://github.com/apache/datafusion/issues/4366)
- Filters/limit are not pushdown druing optimalization for table with alias [\#2270](https://github.com/apache/datafusion/issues/2270)

**Documentation updates:**

- Update README.md fix \[welcoming community\] links [\#5232](https://github.com/apache/datafusion/pull/5232) ([jiangzhx](https://github.com/jiangzhx))
- Update README.md update blaze-rs link to https://github.com/blaze-init/blaze [\#5190](https://github.com/apache/datafusion/pull/5190) ([jiangzhx](https://github.com/jiangzhx))
- Typo of greptimedb [\#5103](https://github.com/apache/datafusion/pull/5103) ([fengjiachun](https://github.com/fengjiachun))
- chore: change `DataBend` to `Databend` [\#5096](https://github.com/apache/datafusion/pull/5096) ([xudong963](https://github.com/xudong963))

**Closed issues:**

- Implement column number / column type verification for sqllogictest [\#4499](https://github.com/apache/datafusion/issues/4499)

**Merged pull requests:**

- generate new projection plan in inline_table_scan instead of discarding [\#5371](https://github.com/apache/datafusion/pull/5371) ([jackwener](https://github.com/jackwener))
- minor: fix rule name and comment. [\#5370](https://github.com/apache/datafusion/pull/5370) ([jackwener](https://github.com/jackwener))
- minor: port limit tests to sqllogictests [\#5355](https://github.com/apache/datafusion/pull/5355) ([jackwener](https://github.com/jackwener))
- feat: add rule to merge projection. [\#5349](https://github.com/apache/datafusion/pull/5349) ([jackwener](https://github.com/jackwener))
- Ignore Arrow in dependabot [\#5341](https://github.com/apache/datafusion/pull/5341) ([iajoiner](https://github.com/iajoiner))
- minor: remove useless `.get()` [\#5336](https://github.com/apache/datafusion/pull/5336) ([jackwener](https://github.com/jackwener))
- bugfix: fix tpcds_logical_q8 ambiguous name. [\#5335](https://github.com/apache/datafusion/pull/5335) ([jackwener](https://github.com/jackwener))
- minor: disable tpcds_logical_q10/q35 [\#5333](https://github.com/apache/datafusion/pull/5333) ([jackwener](https://github.com/jackwener))
- minor: port intersection sql tests to sqllogictests [\#5331](https://github.com/apache/datafusion/pull/5331) ([alamb](https://github.com/alamb))
- minor: port more window tests to sqllogictests [\#5330](https://github.com/apache/datafusion/pull/5330) ([alamb](https://github.com/alamb))
- MINOR: nicer error messages for cli, use display format rather than debug [\#5329](https://github.com/apache/datafusion/pull/5329) ([kmitchener](https://github.com/kmitchener))
- Add missing protobuf serialisation functionality GetIndexedFieldExpr. [\#5324](https://github.com/apache/datafusion/pull/5324) ([ahmedriza](https://github.com/ahmedriza))
- chore: small typo in the example README [\#5319](https://github.com/apache/datafusion/pull/5319) ([gianarb](https://github.com/gianarb))
- feat: add accessor to SessionContext fields for ContextProvider impl [\#5318](https://github.com/apache/datafusion/pull/5318) ([sunng87](https://github.com/sunng87))
- \[DOC\] Update math expression documentation [\#5316](https://github.com/apache/datafusion/pull/5316) ([comphead](https://github.com/comphead))
- Fix nested list indexing when the index is 0 or larger than the list size [\#5311](https://github.com/apache/datafusion/pull/5311) ([ahmedriza](https://github.com/ahmedriza))
- Fix SortExec bench case and Add SortExec input cases to bench for SortPreservingMergeExec [\#5308](https://github.com/apache/datafusion/pull/5308) ([jaylmiller](https://github.com/jaylmiller))
- Allow DISTINCT with ORDER BY and an aliased select list [\#5307](https://github.com/apache/datafusion/pull/5307) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Serialize preserve_partitioning in SortExec [\#5306](https://github.com/apache/datafusion/pull/5306) ([thinkharderdev](https://github.com/thinkharderdev))
- fix: correct plan builder when test `scalar_subquery_project_expr` [\#5304](https://github.com/apache/datafusion/pull/5304) ([jackwener](https://github.com/jackwener))
- Make SQL query consistent with API syntax expression in code examples [\#5303](https://github.com/apache/datafusion/pull/5303) ([ongchi](https://github.com/ongchi))
- enable tpcds-64 test [\#5302](https://github.com/apache/datafusion/pull/5302) ([jackwener](https://github.com/jackwener))
- Feature/merge batches removal [\#5300](https://github.com/apache/datafusion/pull/5300) ([berkaysynnada](https://github.com/berkaysynnada))
- fix: add yield point to `RepartitionExec` [\#5299](https://github.com/apache/datafusion/pull/5299) ([crepererum](https://github.com/crepererum))
- `datafusion.optimizer.repartition_file_scans` enabled by default [\#5295](https://github.com/apache/datafusion/pull/5295) ([korowa](https://github.com/korowa))
- minor: derive Ord/PartialOrd/Eq/PartialEq traits for `ObjectStoreUrl` [\#5288](https://github.com/apache/datafusion/pull/5288) ([crepererum](https://github.com/crepererum))
- Fix the potential bug of check_all_column_from_schema [\#5287](https://github.com/apache/datafusion/pull/5287) ([ygf11](https://github.com/ygf11))
- Linear search support for Window Group queries [\#5286](https://github.com/apache/datafusion/pull/5286) [[sql](https://github.com/apache/datafusion/labels/sql)] ([mustafasrepo](https://github.com/mustafasrepo))
- Prevent optimizer from pruning UnnestExec. [\#5282](https://github.com/apache/datafusion/pull/5282) ([vincev](https://github.com/vincev))
- Minor: Add fetch to SortExec display [\#5279](https://github.com/apache/datafusion/pull/5279) ([thinkharderdev](https://github.com/thinkharderdev))
- Set `catalog_list` from outside for `SessionState`. [\#5277](https://github.com/apache/datafusion/pull/5277) ([MichaelScofield](https://github.com/MichaelScofield))
- Support page skipping / page_index pushdown for evolved schemas [\#5268](https://github.com/apache/datafusion/pull/5268) ([alamb](https://github.com/alamb))
- Use upstream newline_delimited_stream [\#5267](https://github.com/apache/datafusion/pull/5267) ([tustvold](https://github.com/tustvold))
- Support non-tuple expression for exists-subquery to join [\#5264](https://github.com/apache/datafusion/pull/5264) ([ygf11](https://github.com/ygf11))
- minor: Fix cargo fmt [\#5263](https://github.com/apache/datafusion/pull/5263) ([alamb](https://github.com/alamb))
- minor: replace `unwrap()` with `?` [\#5262](https://github.com/apache/datafusion/pull/5262) ([jackwener](https://github.com/jackwener))
- Preserve `TableScan.projection` order in `push_down_projection` optimizer rule [\#5261](https://github.com/apache/datafusion/pull/5261) ([korowa](https://github.com/korowa))
- Minor: refactor ParquetExec roundtrip tests [\#5260](https://github.com/apache/datafusion/pull/5260) ([alamb](https://github.com/alamb))
- \[fix\]\[plan\] relax the check for distinct, order by for dataframe [\#5258](https://github.com/apache/datafusion/pull/5258) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xiaoyong-z](https://github.com/xiaoyong-z))
- enhance the checking of type errors in the test `window_frame_creation` [\#5257](https://github.com/apache/datafusion/pull/5257) ([HaoYang670](https://github.com/HaoYang670))
- SQL planning benchmarks for very wide tables [\#5256](https://github.com/apache/datafusion/pull/5256) ([alamb](https://github.com/alamb))
- Minor: Add negative test for SORT BY [\#5254](https://github.com/apache/datafusion/pull/5254) ([alamb](https://github.com/alamb))
- \[sqllogictest\] Define output types and check them in tests [\#5253](https://github.com/apache/datafusion/pull/5253) ([melgenek](https://github.com/melgenek))
- Minor: port some explain test to sqllogictest, add filename normalization [\#5252](https://github.com/apache/datafusion/pull/5252) ([alamb](https://github.com/alamb))
- Disallow SORT BY in SQL [\#5249](https://github.com/apache/datafusion/pull/5249) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jefffrey](https://github.com/Jefffrey))
- \[SQLLogicTest\] Make schema validation ignore nullable and metadata attributes [\#5246](https://github.com/apache/datafusion/pull/5246) ([comphead](https://github.com/comphead))
- Add SQL function overload LOG\(base, x\) for logarithm of x to base [\#5245](https://github.com/apache/datafusion/pull/5245) ([comphead](https://github.com/comphead))
- Update sqllogictest requirement from 0.11.1 to 0.12.0 \#5237 [\#5244](https://github.com/apache/datafusion/pull/5244) ([alamb](https://github.com/alamb))
- Test case for NDJsonExec with randomly ordered projection [\#5243](https://github.com/apache/datafusion/pull/5243) ([korowa](https://github.com/korowa))
- Update to arrow `33.0.0` [\#5241](https://github.com/apache/datafusion/pull/5241) [[sql](https://github.com/apache/datafusion/labels/sql)] ([tustvold](https://github.com/tustvold))
- DataFusion 18.0.0 Release [\#5240](https://github.com/apache/datafusion/pull/5240) [[sql](https://github.com/apache/datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- fix clippy in nightly [\#5238](https://github.com/apache/datafusion/pull/5238) ([jackwener](https://github.com/jackwener))
- refactor: correct the implementation of `all_schemas()` [\#5236](https://github.com/apache/datafusion/pull/5236) ([jackwener](https://github.com/jackwener))
- bugfix: fix error when `get_coerced_window_frame` meet `utf8` [\#5234](https://github.com/apache/datafusion/pull/5234) ([jackwener](https://github.com/jackwener))
- Feature/sort enforcement refactor [\#5228](https://github.com/apache/datafusion/pull/5228) ([mustafasrepo](https://github.com/mustafasrepo))
- Minor: Fix doc links and typos [\#5225](https://github.com/apache/datafusion/pull/5225) ([Jefffrey](https://github.com/Jefffrey))
- fix: correct expected error in test [\#5224](https://github.com/apache/datafusion/pull/5224) ([jackwener](https://github.com/jackwener))
- bugfix: fix propagating empty_relation generates an illegal plan [\#5219](https://github.com/apache/datafusion/pull/5219) ([yukkit](https://github.com/yukkit))
- Replace placeholders in ScalarSubqueries [\#5216](https://github.com/apache/datafusion/pull/5216) [[sql](https://github.com/apache/datafusion/labels/sql)] ([avantgardnerio](https://github.com/avantgardnerio))
- Dataframe join_on method [\#5210](https://github.com/apache/datafusion/pull/5210) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jefffrey](https://github.com/Jefffrey))
- bugfix: fix eval `nullalbe()` in `simplify_exprs` [\#5208](https://github.com/apache/datafusion/pull/5208) ([jackwener](https://github.com/jackwener))
- minor: remove unnecessary clone [\#5207](https://github.com/apache/datafusion/pull/5207) ([Ted-Jiang](https://github.com/Ted-Jiang))
- minor: extract `merge_schema()` function. [\#5203](https://github.com/apache/datafusion/pull/5203) ([jackwener](https://github.com/jackwener))
- minor: remove unnecessary `continue` [\#5200](https://github.com/apache/datafusion/pull/5200) ([xiaoyong-z](https://github.com/xiaoyong-z))
- Minor: Begin porting some window tests to sqllogictests [\#5199](https://github.com/apache/datafusion/pull/5199) ([alamb](https://github.com/alamb))
- fix\(MemTable\): make it cancel-safe and fix parallelism [\#5197](https://github.com/apache/datafusion/pull/5197) ([DDtKey](https://github.com/DDtKey))
- fix: make `write_csv/json/parquet` cancel-safe [\#5196](https://github.com/apache/datafusion/pull/5196) ([DDtKey](https://github.com/DDtKey))
- Support arithmetic operation on DictionaryArray [\#5194](https://github.com/apache/datafusion/pull/5194) ([viirya](https://github.com/viirya))
- sqllogicaltest: add cleanup and use rowsort. [\#5189](https://github.com/apache/datafusion/pull/5189) ([jackwener](https://github.com/jackwener))
- bugfix: fix `TableScan` may contain fields not included in `schema` [\#5188](https://github.com/apache/datafusion/pull/5188) ([jackwener](https://github.com/jackwener))
- Create disk manager spill folder if doesn't exist [\#5185](https://github.com/apache/datafusion/pull/5185) ([comphead](https://github.com/comphead))
- Parse identifiers properly for TableReferences [\#5183](https://github.com/apache/datafusion/pull/5183) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jefffrey](https://github.com/Jefffrey))
- Fix decimal scalar dyn kernels [\#5179](https://github.com/apache/datafusion/pull/5179) ([viirya](https://github.com/viirya))
- Patch git Safe Paths in CI [\#5177](https://github.com/apache/datafusion/pull/5177) ([tustvold](https://github.com/tustvold))
- Add initial support for serializing physical plans with Substrait [\#5176](https://github.com/apache/datafusion/pull/5176) ([andygrove](https://github.com/andygrove))
- Bump tokio from 1.24.1 to 1.24.2 in /datafusion-cli [\#5172](https://github.com/apache/datafusion/pull/5172) ([dependabot[bot]](https://github.com/apps/dependabot))
- Make EnforceSorting global sort aware, fix sort mis-optimizations involving unions, support parallel sort + merge transformations [\#5171](https://github.com/apache/datafusion/pull/5171) ([mustafasrepo](https://github.com/mustafasrepo))
- Update substrait README.md [\#5168](https://github.com/apache/datafusion/pull/5168) ([jiangzhx](https://github.com/jiangzhx))
- Switch to use sum kernel from arrow-rs for Decimal128 [\#5167](https://github.com/apache/datafusion/pull/5167) ([sunchao](https://github.com/sunchao))
- FileStream: Open next file in parallel while decoding [\#5161](https://github.com/apache/datafusion/pull/5161) ([thinkharderdev](https://github.com/thinkharderdev))
- Fix FairSpillPool try_grow for non-spillable consumers [\#5160](https://github.com/apache/datafusion/pull/5160) ([tustvold](https://github.com/tustvold))
- fix: treat unsupported SQL plans as "not implemented" [\#5159](https://github.com/apache/datafusion/pull/5159) ([crepererum](https://github.com/crepererum))
- Compare NULL types [\#5158](https://github.com/apache/datafusion/pull/5158) ([melgenek](https://github.com/melgenek))
- Always wrapping OnceAsync for the inner table side in NestedLoopJoinExec [\#5156](https://github.com/apache/datafusion/pull/5156) ([ygf11](https://github.com/ygf11))
- chore: add object_name_to_table_reference in SqlToRel [\#5155](https://github.com/apache/datafusion/pull/5155) [[sql](https://github.com/apache/datafusion/labels/sql)] ([jiacai2050](https://github.com/jiacai2050))
- Ambiguity check for where selection [\#5153](https://github.com/apache/datafusion/pull/5153) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jefffrey](https://github.com/Jefffrey))
- feat: Type coercion for Dictionary\(\_, \_\) to Utf8 for regex conditions [\#5152](https://github.com/apache/datafusion/pull/5152) ([stuartcarnie](https://github.com/stuartcarnie))
- Support arithmetic scalar operation with DictionaryArray [\#5151](https://github.com/apache/datafusion/pull/5151) ([viirya](https://github.com/viirya))
- \[sqllogictest\] Support `pg_typeof` [\#5148](https://github.com/apache/datafusion/pull/5148) ([melgenek](https://github.com/melgenek))
- Date to Timestamp cast [\#5140](https://github.com/apache/datafusion/pull/5140) ([comphead](https://github.com/comphead))
- add example for Flight SQL server that supports JDBC driver [\#5138](https://github.com/apache/datafusion/pull/5138) ([kmitchener](https://github.com/kmitchener))
- Add in-list test [\#5135](https://github.com/apache/datafusion/pull/5135) ([nseekhao](https://github.com/nseekhao))
- \[BugFix\] abort plan if order by column not in select list [\#5132](https://github.com/apache/datafusion/pull/5132) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xiaoyong-z](https://github.com/xiaoyong-z))
- Bug fix: Empty Record Batch handling [\#5131](https://github.com/apache/datafusion/pull/5131) ([mustafasrepo](https://github.com/mustafasrepo))
- Add option to control whether to normalize ident [\#5124](https://github.com/apache/datafusion/pull/5124) [[sql](https://github.com/apache/datafusion/labels/sql)] ([jiacai2050](https://github.com/jiacai2050))
- Make `parse_physical_expr` public [\#5118](https://github.com/apache/datafusion/pull/5118) ([comphead](https://github.com/comphead))
- Support coercing `utf8` to `interval` and `timestamp` \(including arguments to `date_bin`\) [\#5117](https://github.com/apache/datafusion/pull/5117) ([alamb](https://github.com/alamb))
- Fix release issues [\#5116](https://github.com/apache/datafusion/pull/5116) [[sql](https://github.com/apache/datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- minor: port date_bin tests to sqllogictests [\#5115](https://github.com/apache/datafusion/pull/5115) ([alamb](https://github.com/alamb))
- Minor: reduce code duplication using `rewrite_expr` [\#5114](https://github.com/apache/datafusion/pull/5114) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Replace &Option\<T\> with Option\<&T\> [\#5113](https://github.com/apache/datafusion/pull/5113) ([gaoxinge](https://github.com/gaoxinge))
- Improve `get_meet_of_orderings` to check for common prefixes [\#5111](https://github.com/apache/datafusion/pull/5111) ([ozankabak](https://github.com/ozankabak))
- \[sqllogictest\] Apply rowsort when there is no explicit order by [\#5110](https://github.com/apache/datafusion/pull/5110) ([melgenek](https://github.com/melgenek))
- Add unnest_column to DataFrame [\#5106](https://github.com/apache/datafusion/pull/5106) ([vincev](https://github.com/vincev))
- Minor: reduce indent level in page filter pruning code [\#5105](https://github.com/apache/datafusion/pull/5105) ([alamb](https://github.com/alamb))
- Replace &Option\<T\> with Option\<&T\> [\#5102](https://github.com/apache/datafusion/pull/5102) ([gaoxinge](https://github.com/gaoxinge))
- Minor: remove unused methods in datafusion/optimizer/src/utils.rs [\#5098](https://github.com/apache/datafusion/pull/5098) ([ygf11](https://github.com/ygf11))
- ci: don't trigger rust ci for doc changes [\#5097](https://github.com/apache/datafusion/pull/5097) ([xudong963](https://github.com/xudong963))
- sqllogicaltest: fix unstable slt case. [\#5095](https://github.com/apache/datafusion/pull/5095) ([jackwener](https://github.com/jackwener))
- chore: update cranelift-module [\#5094](https://github.com/apache/datafusion/pull/5094) ([jackwener](https://github.com/jackwener))
- refactor: Add `rewrite_expr` convenience method for rewriting `Expr`s [\#5092](https://github.com/apache/datafusion/pull/5092) ([alamb](https://github.com/alamb))
- Minor: extract sort col rewrite into its own module, add unit tests [\#5088](https://github.com/apache/datafusion/pull/5088) ([alamb](https://github.com/alamb))
- \[sqllogictest\] Move `decimal.rs` tests [\#5086](https://github.com/apache/datafusion/pull/5086) ([melgenek](https://github.com/melgenek))
- Insert target columns empty fix [\#5079](https://github.com/apache/datafusion/pull/5079) [[sql](https://github.com/apache/datafusion/labels/sql)] ([gruuya](https://github.com/gruuya))
- sqllogicaltest: move union.rs [\#5075](https://github.com/apache/datafusion/pull/5075) ([jackwener](https://github.com/jackwener))
- \[Enhancement\] Don't repartition ProjectionExec when it does not compute anything [\#5074](https://github.com/apache/datafusion/pull/5074) ([xiaoyong-z](https://github.com/xiaoyong-z))
- Support ORDER BY an aliased column [\#5067](https://github.com/apache/datafusion/pull/5067) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Parquet parallel scan [\#5057](https://github.com/apache/datafusion/pull/5057) ([korowa](https://github.com/korowa))
- \[BugFix\] fix file stream time scanning metrics bug [\#5020](https://github.com/apache/datafusion/pull/5020) ([xiaoyong-z](https://github.com/xiaoyong-z))
- Show optimization errors in explain [\#4819](https://github.com/apache/datafusion/pull/4819) [[sql](https://github.com/apache/datafusion/labels/sql)] ([Jefffrey](https://github.com/Jefffrey))
