/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaAnotBimpl;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.ThetaUnionImpl;
import org.apache.datasketches.thetacommon.ThetaUtil;

public final class ThetaSetOperationBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private float bP = 1.0f;

    public ThetaSetOperationBuilder setNominalEntries(int nomEntries) {
        this.bLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        if (this.bLgNomLongs > 26 || this.bLgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomEntries);
        }
        return this;
    }

    public ThetaSetOperationBuilder setLogNominalEntries(int lgNomEntries) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(1 << lgNomEntries);
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public ThetaSetOperationBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public ThetaSetOperationBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new SketchesArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public ThetaSetOperationBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public ThetaSetOperation build(Family family) {
        return this.build(family, null);
    }

    public ThetaSetOperation build(Family family, MemorySegment dstSeg) {
        ThetaSetOperation setOp = null;
        switch (family) {
            case UNION: {
                if (dstSeg == null) {
                    setOp = ThetaUnionImpl.initNewHeapInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                setOp = ThetaUnionImpl.initNewDirectInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, dstSeg);
                break;
            }
            case INTERSECTION: {
                if (dstSeg == null) {
                    setOp = ThetaIntersectionImpl.initNewHeapInstance(this.bSeed);
                    break;
                }
                setOp = ThetaIntersectionImpl.initNewDirectInstance(this.bSeed, dstSeg);
                break;
            }
            case A_NOT_B: {
                if (dstSeg == null) {
                    setOp = new ThetaAnotBimpl(this.bSeed);
                    break;
                }
                throw new SketchesArgumentException("ThetaAnotB can not be persisted.");
            }
            default: {
                throw new SketchesArgumentException("Given Family cannot be built as a ThetaSetOperation: " + family.toString());
            }
        }
        return setOp;
    }

    public ThetaUnion buildUnion() {
        return (ThetaUnion)this.build(Family.UNION);
    }

    public ThetaUnion buildUnion(MemorySegment dstSeg) {
        return (ThetaUnion)this.build(Family.UNION, dstSeg);
    }

    public ThetaIntersection buildIntersection() {
        return (ThetaIntersection)this.build(Family.INTERSECTION);
    }

    public ThetaIntersection buildIntersection(MemorySegment dstSeg) {
        return (ThetaIntersection)this.build(Family.INTERSECTION, dstSeg);
    }

    public ThetaAnotB buildANotB() {
        return (ThetaAnotB)this.build(Family.A_NOT_B);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SetOperationBuilder configuration:").append(Util.LS);
        sb.append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS);
        sb.append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS);
        sb.append("Seed:").append('\t').append(this.bSeed).append(Util.LS);
        sb.append("p:").append('\t').append(this.bP).append(Util.LS);
        sb.append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS);
        return sb.toString();
    }
}

