/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import lombok.Generated;
import org.quartz.JobKey;

public class QuartzJobKey {
    private final int schedulerId;
    private final int projectId;
    private static final String QUARTZ_JOB_PREFIX = "job";
    private static final String QUARTZ_JOB_GROUP_PREFIX = "jobgroup";
    private static final String UNDERLINE = "_";

    private QuartzJobKey(int projectId, int schedulerId) {
        this.schedulerId = schedulerId;
        this.projectId = projectId;
    }

    public static QuartzJobKey of(int projectId, int schedulerId) {
        return new QuartzJobKey(projectId, schedulerId);
    }

    public JobKey toJobKey() {
        String jobName = "job_" + this.schedulerId;
        String jobGroup = "jobgroup_" + this.projectId;
        return new JobKey(jobName, jobGroup);
    }

    @Generated
    public int getSchedulerId() {
        return this.schedulerId;
    }

    @Generated
    public int getProjectId() {
        return this.projectId;
    }
}

