/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.EncryptionProtectorInner;
import com.azure.resourcemanager.sql.implementation.SqlEncryptionProtectorImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.EncryptionProtectorName;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtector;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtectorOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlEncryptionProtectorOperationsImpl
implements SqlEncryptionProtectorOperations,
SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlEncryptionProtectorOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        Objects.requireNonNull(parent);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlEncryptionProtectorOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlEncryptionProtector getBySqlServer(String resourceGroupName, String sqlServerName) {
        EncryptionProtectorInner encryptionProtectorInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().get(resourceGroupName, sqlServerName, EncryptionProtectorName.CURRENT);
        return encryptionProtectorInner != null ? new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, encryptionProtectorInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlEncryptionProtector> getBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlEncryptionProtectorOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().getAsync(resourceGroupName, sqlServerName, EncryptionProtectorName.CURRENT).map(encryptionProtectorInner -> new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, (EncryptionProtectorInner)((Object)encryptionProtectorInner), self.sqlServerManager));
    }

    @Override
    public SqlEncryptionProtector getBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        EncryptionProtectorInner encryptionProtectorInner = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getEncryptionProtectors().get(sqlServer.resourceGroupName(), sqlServer.name(), EncryptionProtectorName.CURRENT);
        return encryptionProtectorInner != null ? new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, encryptionProtectorInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlEncryptionProtector> getBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getEncryptionProtectors().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), EncryptionProtectorName.CURRENT).map(encryptionProtectorInner -> new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, (EncryptionProtectorInner)((Object)encryptionProtectorInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public SqlEncryptionProtector get() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer);
    }

    @Override
    public Mono<SqlEncryptionProtector> getAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer);
    }

    @Override
    public SqlEncryptionProtector getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public Mono<SqlEncryptionProtector> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public List<SqlEncryptionProtector> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer);
    }

    @Override
    public PagedFlux<SqlEncryptionProtector> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer);
    }

    @Override
    public List<SqlEncryptionProtector> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlEncryptionProtectorImpl> encryptionProtectors = new ArrayList<SqlEncryptionProtectorImpl>();
        PagedIterable<EncryptionProtectorInner> encryptionProtectorInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().listByServer(resourceGroupName, sqlServerName);
        for (EncryptionProtectorInner inner : encryptionProtectorInners) {
            encryptionProtectors.add(new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(encryptionProtectors);
    }

    @Override
    public PagedFlux<SqlEncryptionProtector> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlEncryptionProtectorOperationsImpl self = this;
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().listByServerAsync(resourceGroupName, sqlServerName), encryptionProtectorInner -> new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, (EncryptionProtectorInner)((Object)encryptionProtectorInner), self.sqlServerManager));
    }

    @Override
    public List<SqlEncryptionProtector> listBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ArrayList<SqlEncryptionProtectorImpl> encryptionProtectors = new ArrayList<SqlEncryptionProtectorImpl>();
        PagedIterable<EncryptionProtectorInner> encryptionProtectorInners = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getEncryptionProtectors().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        for (EncryptionProtectorInner inner : encryptionProtectorInners) {
            encryptionProtectors.add(new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())));
        }
        return Collections.unmodifiableList(encryptionProtectors);
    }

    @Override
    public PagedFlux<SqlEncryptionProtector> listBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getEncryptionProtectors().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()), encryptionProtectorInner -> new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, (EncryptionProtectorInner)((Object)encryptionProtectorInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }
}

