/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm.models.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.models.ResourceGroup;

public abstract class GroupableResourceImpl<FluentModelT extends Resource, InnerModelT extends com.azure.core.management.Resource, FluentModelImplT extends GroupableResourceImpl<FluentModelT, InnerModelT, FluentModelImplT, ManagerT>, ManagerT extends Manager<?>>
extends ResourceImpl<FluentModelT, InnerModelT, FluentModelImplT>
implements GroupableResource<ManagerT, InnerModelT> {
    protected final ManagerT myManager;
    protected Creatable<ResourceGroup> creatableGroup;
    private String groupName;

    protected GroupableResourceImpl(String name, InnerModelT innerObject, ManagerT manager) {
        super(name, innerObject);
        this.myManager = manager;
    }

    protected String resourceIdBase() {
        return "/subscriptions/" + ((Manager)this.myManager).subscriptionId() + "/resourceGroups/" + this.resourceGroupName();
    }

    @Override
    public ManagerT manager() {
        return this.myManager;
    }

    @Override
    public String resourceGroupName() {
        if (this.groupName == null) {
            return ResourceUtils.groupFromResourceId(this.id());
        }
        return this.groupName;
    }

    protected Creatable<ResourceGroup> creatableGroup() {
        return this.creatableGroup;
    }

    public final FluentModelImplT withNewResourceGroup(String groupName) {
        return this.withNewResourceGroup((Creatable)((ResourceGroup.DefinitionStages.Blank)((Manager)this.myManager).resourceManager().resourceGroups().define(groupName)).withRegion(this.regionName()));
    }

    public final FluentModelImplT withNewResourceGroup(String groupName, Region region) {
        return this.withNewResourceGroup((Creatable)((ResourceGroup.DefinitionStages.Blank)((Manager)this.myManager).resourceManager().resourceGroups().define(groupName)).withRegion(region));
    }

    public final FluentModelImplT withNewResourceGroup() {
        return this.withNewResourceGroup(this.name() + "group");
    }

    public final FluentModelImplT withNewResourceGroup(Region region) {
        return this.withNewResourceGroup(this.name() + "group", region);
    }

    public final FluentModelImplT withNewResourceGroup(Creatable<ResourceGroup> creatable) {
        this.groupName = creatable.name();
        this.creatableGroup = creatable;
        this.addDependency(creatable);
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withExistingResourceGroup(String groupName) {
        this.groupName = groupName;
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withExistingResourceGroup(ResourceGroup group) {
        return this.withExistingResourceGroup(group.name());
    }
}

