/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.DefineUserDto;
import org.apache.dolphinscheduler.api.dto.TaskCountDto;
import org.apache.dolphinscheduler.api.dto.project.StatisticsStateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataAnalysisService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="STATISTICS_V2")
@RestController
@RequestMapping(value={"/v2/statistics"})
public class StatisticsV2Controller
extends BaseController {
    @Autowired
    private DataAnalysisService dataAnalysisService;

    @Operation(summary="queryAllWorkflowStatesCount", description="QUERY_ALL_WORKFLOW_STATES_COUNT")
    @GetMapping(value={"/workflows/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_WORKFLOW_STATES_COUNT_ERROR)
    public Result<TaskCountDto> queryWorkflowStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        TaskCountDto taskCountDto = this.dataAnalysisService.countWorkflowStates(loginUser, statisticsStateRequest);
        return Result.success(taskCountDto);
    }

    @Operation(summary="queryOneWorkflowStatesCount", description="QUERY_One_WORKFLOW_STATES_COUNT")
    @GetMapping(value={"/{workflowCode}/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ONE_WORKFLOW_STATE_COUNT_ERROR)
    public Result<TaskCountDto> queryOneWorkflowStates(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="workflowCode") Long workflowCode) {
        TaskCountDto taskCountDto = this.dataAnalysisService.countOneWorkflowStates(loginUser, workflowCode);
        return Result.success(taskCountDto);
    }

    @Operation(summary="queryAllTaskStatesCount", description="QUERY_ALL_TASK_STATES_COUNT")
    @GetMapping(value={"/tasks/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_STATES_COUNT_ERROR)
    public Result<TaskCountDto> queryTaskStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        TaskCountDto taskCountDto = this.dataAnalysisService.countTaskStates(loginUser, statisticsStateRequest);
        return Result.success(taskCountDto);
    }

    @Operation(summary="queryOneTaskStatesCount", description="QUERY_ONE_TASK_STATES_COUNT")
    @GetMapping(value={"/tasks/{taskCode}/states/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ONE_TASK_STATES_COUNT_ERROR)
    public Result<TaskCountDto> queryOneTaskStatesCounts(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="taskCode") Long taskCode) {
        TaskCountDto taskCountDto = this.dataAnalysisService.countOneTaskStates(loginUser, taskCode);
        return Result.success(taskCountDto);
    }

    @Operation(summary="countDefinitionV2ByUserId", description="COUNT_WORKFLOW_DEFINITION_V2_BY_USERID_NOTES")
    @GetMapping(value={"/workflows/users/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_WORKFLOW_DEFINITION_USER_ERROR)
    public Result<DefineUserDto> countDefinitionByUser(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestBody(required=false) StatisticsStateRequest statisticsStateRequest) {
        throw new UnsupportedOperationException("not supported");
    }

    @Operation(summary="countDefinitionV2ByUser", description="COUNT_WORKFLOW_DEFINITION_V2_BY_USER_NOTES")
    @GetMapping(value={"/workflows/users/{userId}/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_WORKFLOW_DEFINITION_USER_ERROR)
    public Result<DefineUserDto> countDefinitionByUserId(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId) {
        DefineUserDto defineUserDto = this.dataAnalysisService.countDefinitionByUserV2(loginUser, userId, null);
        return Result.success(defineUserDto);
    }

    @Operation(summary="countDefinitionV2ByUser", description="COUNT_WORKFLOW_DEFINITION_V2_BY_USER_NOTES")
    @GetMapping(value={"/workflows/users/{userId}/{releaseState}/count"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.COUNT_WORKFLOW_DEFINITION_USER_ERROR)
    public Result<DefineUserDto> countDefinitionByUserState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="userId") Integer userId, @PathVariable(value="releaseState") Integer releaseState) {
        DefineUserDto defineUserDto = this.dataAnalysisService.countDefinitionByUserV2(loginUser, userId, releaseState);
        return Result.success(defineUserDto);
    }
}

