/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.DynamicsSinkWriteBehavior;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="DynamicsSink")
public final class DynamicsSink
extends CopySink {
    @JsonProperty(value="writeBehavior", required=true)
    private DynamicsSinkWriteBehavior writeBehavior;
    @JsonProperty(value="ignoreNullValues")
    private Object ignoreNullValues;
    @JsonProperty(value="alternateKeyName")
    private Object alternateKeyName;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicsSink.class);

    public DynamicsSinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    public DynamicsSink withWriteBehavior(DynamicsSinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    public DynamicsSink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    public Object alternateKeyName() {
        return this.alternateKeyName;
    }

    public DynamicsSink withAlternateKeyName(Object alternateKeyName) {
        this.alternateKeyName = alternateKeyName;
        return this;
    }

    @Override
    public DynamicsSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public DynamicsSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public DynamicsSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public DynamicsSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public DynamicsSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public DynamicsSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.writeBehavior() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property writeBehavior in model DynamicsSink"));
        }
    }
}

