/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeResourceInner;
import com.azure.resourcemanager.datafactory.models.CreateLinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAuthKeys;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAutoUpdate;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeConnectionInfo;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeMonitoringData;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeRegenerateKeyParameters;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatusResponse;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeRequest;

public interface IntegrationRuntimeResource {
    public String id();

    public IntegrationRuntime properties();

    public String name();

    public String type();

    public String etag();

    public String resourceGroupName();

    public IntegrationRuntimeResourceInner innerModel();

    public Update update();

    public IntegrationRuntimeResource refresh();

    public IntegrationRuntimeResource refresh(Context var1);

    public Response<IntegrationRuntimeStatusResponse> getStatusWithResponse(Context var1);

    public IntegrationRuntimeStatusResponse getStatus();

    public Response<IntegrationRuntimeConnectionInfo> getConnectionInfoWithResponse(Context var1);

    public IntegrationRuntimeConnectionInfo getConnectionInfo();

    public Response<IntegrationRuntimeAuthKeys> regenerateAuthKeyWithResponse(IntegrationRuntimeRegenerateKeyParameters var1, Context var2);

    public IntegrationRuntimeAuthKeys regenerateAuthKey(IntegrationRuntimeRegenerateKeyParameters var1);

    public Response<IntegrationRuntimeAuthKeys> listAuthKeysWithResponse(Context var1);

    public IntegrationRuntimeAuthKeys listAuthKeys();

    public IntegrationRuntimeStatusResponse start();

    public IntegrationRuntimeStatusResponse start(Context var1);

    public void stop();

    public void stop(Context var1);

    public Response<Void> syncCredentialsWithResponse(Context var1);

    public void syncCredentials();

    public Response<IntegrationRuntimeMonitoringData> getMonitoringDataWithResponse(Context var1);

    public IntegrationRuntimeMonitoringData getMonitoringData();

    public Response<Void> upgradeWithResponse(Context var1);

    public void upgrade();

    public Response<Void> removeLinksWithResponse(LinkedIntegrationRuntimeRequest var1, Context var2);

    public void removeLinks(LinkedIntegrationRuntimeRequest var1);

    public Response<IntegrationRuntimeStatusResponse> createLinkedIntegrationRuntimeWithResponse(CreateLinkedIntegrationRuntimeRequest var1, Context var2);

    public IntegrationRuntimeStatusResponse createLinkedIntegrationRuntime(CreateLinkedIntegrationRuntimeRequest var1);

    public static interface UpdateStages {

        public static interface WithUpdateDelayOffset {
            public Update withUpdateDelayOffset(String var1);
        }

        public static interface WithAutoUpdate {
            public Update withAutoUpdate(IntegrationRuntimeAutoUpdate var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithAutoUpdate,
    UpdateStages.WithUpdateDelayOffset {
        public IntegrationRuntimeResource apply();

        public IntegrationRuntimeResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithCreate
        extends WithIfMatch {
            public IntegrationRuntimeResource create();

            public IntegrationRuntimeResource create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(IntegrationRuntime var1);
        }

        public static interface WithParentResource {
            public WithProperties withExistingFactory(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

