/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.util.taints.Taints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class KubectlTaint
extends Kubectl.ResourceBuilder<V1Node, KubectlTaint>
implements Kubectl.Executable<V1Node> {
    private final Map<String, Pair<String, String>> addingTaints = new HashMap<String, Pair<String, String>>();
    private final Map<String, String> removeTaints = new HashMap<String, String>();

    KubectlTaint() {
        super(V1Node.class);
    }

    public KubectlTaint addTaint(String key, String effect) {
        return this.addTaint(key, null, effect);
    }

    public KubectlTaint addTaint(String key, String value, String effect) {
        this.addingTaints.put(key, (Pair<String, String>)new ImmutablePair((Object)value, (Object)effect));
        return this;
    }

    public KubectlTaint removeTaint(String key) {
        this.removeTaints.put(key, null);
        return this;
    }

    public KubectlTaint removeTaint(String key, String effect) {
        this.removeTaints.put(key, effect);
        return this;
    }

    @Override
    public V1Node execute() throws KubectlException {
        this.verifyArguments();
        try {
            return this.executeInternal();
        }
        catch (ApiException | IOException ex) {
            throw new KubectlException(ex);
        }
    }

    private V1Node executeInternal() throws KubectlException, ApiException, IOException {
        CoreV1Api v1 = new CoreV1Api(this.apiClient);
        V1Node node = v1.readNode(this.name, null, null, null);
        Taints.TaintsBuilder builder = Taints.taints((V1Node)node);
        for (Map.Entry<String, Pair<String, String>> entry : this.addingTaints.entrySet()) {
            builder.addTaint(entry.getKey(), (String)entry.getValue().getLeft(), this.makeEffect((String)entry.getValue().getRight()));
        }
        for (Map.Entry<String, Object> entry : this.removeTaints.entrySet()) {
            if (entry.getValue() == null) {
                builder.removeTaint(entry.getKey());
                continue;
            }
            builder.removeTaint(entry.getKey(), this.makeEffect((String)entry.getValue()));
        }
        return v1.replaceNode(this.name, node, null, null, null);
    }

    private Taints.Effect makeEffect(String effect) throws KubectlException {
        if (effect.equals(Taints.Effect.NO_SCHEDULE.toString())) {
            return Taints.Effect.NO_SCHEDULE;
        }
        if (effect.equals(Taints.Effect.PREFER_NO_SCHEDULE.toString())) {
            return Taints.Effect.PREFER_NO_SCHEDULE;
        }
        if (effect.equals(Taints.Effect.NO_EXECUTE.toString())) {
            return Taints.Effect.NO_EXECUTE;
        }
        throw new KubectlException("Unknown effect: " + effect);
    }

    private void verifyArguments() throws KubectlException {
        if (null == this.name) {
            throw new KubectlException("missing name argument");
        }
    }
}

