/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.ARecord;
import com.azure.resourcemanager.privatedns.models.ARecordSet;
import com.azure.resourcemanager.privatedns.models.RecordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ARecordSetImpl
extends PrivateDnsRecordSetImpl
implements ARecordSet {
    ARecordSetImpl(String name, PrivateDnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.A.toString(), parent, innerModel);
    }

    static ARecordSetImpl newRecordSet(String name, PrivateDnsZoneImpl parent) {
        return new ARecordSetImpl(name, parent, new RecordSetInner().withARecords(new ArrayList<ARecord>()));
    }

    @Override
    public List<String> ipv4Addresses() {
        ArrayList<String> ipv4Addresses = new ArrayList<String>();
        if (((RecordSetInner)((Object)this.innerModel())).aRecords() != null) {
            for (ARecord aRecord : ((RecordSetInner)((Object)this.innerModel())).aRecords()) {
                ipv4Addresses.add(aRecord.ipv4Address());
            }
        }
        return Collections.unmodifiableList(ipv4Addresses);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)((Object)this.innerModel())).aRecords() != null && !((RecordSetInner)((Object)this.innerModel())).aRecords().isEmpty()) {
            if (resource.aRecords() == null) {
                resource.withARecords(new ArrayList<ARecord>());
            }
            resource.aRecords().addAll(((RecordSetInner)((Object)this.innerModel())).aRecords());
            ((RecordSetInner)((Object)this.innerModel())).aRecords().clear();
        }
        if (!this.recordSetRemoveInfo.aRecords().isEmpty()) {
            if (resource.aRecords() != null) {
                block0: for (ARecord recordToRemove : this.recordSetRemoveInfo.aRecords()) {
                    for (ARecord record : resource.aRecords()) {
                        if (!record.ipv4Address().equalsIgnoreCase(recordToRemove.ipv4Address())) continue;
                        resource.aRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.aRecords().clear();
        }
        return resource;
    }
}

