/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import java.util.concurrent.CompletableFuture;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory) {
        this.config = config;
        this.factory = factory;
    }

    @Override
    public CompletableFuture<Boolean> afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        if (response.code() == 401) {
            Config newestConfig;
            String currentContextName = null;
            CompletableFuture<String> newAccessToken = null;
            if (this.config.getCurrentContext() != null) {
                currentContextName = this.config.getCurrentContext().getName();
            }
            newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder()) : CompletableFuture.completedFuture(newestConfig.getOauthToken());
            return newAccessToken.thenApply(s -> {
                if (s != null) {
                    headerBuilder.setHeader("Authorization", "Bearer " + s);
                    this.config.setOauthToken((String)s);
                    return true;
                }
                return false;
            });
        }
        return CompletableFuture.completedFuture(false);
    }
}

