/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.controller;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import io.kubernetes.client.spring.extended.controller.config.KubernetesInformerProperties;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Deprecated
public class KubernetesInformerFactoryProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KubernetesInformerFactoryProcessor.class);
    public static final int ORDER = 0;
    @Autowired
    private KubernetesInformerProperties informerProperties;
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return 0;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!(registry instanceof BeanFactory)) {
            return;
        }
        for (String name : registry.getBeanDefinitionNames()) {
            KubernetesInformers kubernetesInformers = null;
            Class cls = ((BeanFactory)registry).getType(name);
            if (cls != null) {
                kubernetesInformers = (KubernetesInformers)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)cls, KubernetesInformers.class);
            }
            if (kubernetesInformers == null) {
                kubernetesInformers = (KubernetesInformers)this.beanFactory.findAnnotationOnBean(name, KubernetesInformers.class);
            }
            if (kubernetesInformers == null || kubernetesInformers.value().length <= 0) continue;
            for (KubernetesInformer kubernetesInformer : kubernetesInformers.value()) {
                this.registerInformer(registry, kubernetesInformer);
                this.registerLister(registry, kubernetesInformer);
            }
        }
    }

    private void registerInformer(BeanDefinitionRegistry registry, KubernetesInformer kubernetesInformer) {
        RootBeanDefinition informerBean = (RootBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(SharedInformer.class).getBeanDefinition();
        informerBean.setInstanceSupplier(() -> this.informer(kubernetesInformer.apiTypeClass(), kubernetesInformer));
        ResolvableType informerType = ResolvableType.forClassWithGenerics(SharedIndexInformer.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
        informerBean.setTargetType(informerType);
        registry.registerBeanDefinition(this.getInformerBeanName(kubernetesInformer.apiTypeClass()), (BeanDefinition)informerBean);
    }

    private String getInformerBeanName(Class<?> type) {
        return type.getName() + "Informer";
    }

    private void registerLister(BeanDefinitionRegistry registry, KubernetesInformer kubernetesInformer) {
        RootBeanDefinition listerBean = (RootBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(Lister.class).getBeanDefinition();
        listerBean.setInstanceSupplier(() -> this.lister(kubernetesInformer.apiTypeClass()));
        ResolvableType listerType = ResolvableType.forClassWithGenerics(Lister.class, (Class[])new Class[]{kubernetesInformer.apiTypeClass()});
        listerBean.setTargetType(listerType);
        registry.registerBeanDefinition(listerType.toString(), (BeanDefinition)listerBean);
    }

    private <T extends KubernetesObject> Lister<T> lister(Class<T> type) {
        SharedIndexInformer sharedInformer = (SharedIndexInformer)this.beanFactory.getBean(this.getInformerBeanName(type), SharedIndexInformer.class);
        Lister lister = new Lister(sharedInformer.getIndexer());
        return lister;
    }

    private <T extends KubernetesObject> SharedInformer<T> informer(Class<T> type, KubernetesInformer kubernetesInformer) {
        ApiClient apiClient = (ApiClient)this.beanFactory.getBean(ApiClient.class);
        if (apiClient.getHttpClient().readTimeoutMillis() > 0) {
            log.warn("Enforcing read-timeout of the ApiClient {} to {} so that the watch connection won't abort from client-side", (Object)apiClient, (Object)this.informerProperties.getClientReadTimeout());
            apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(this.informerProperties.getClientReadTimeout()).build());
        }
        SharedInformerFactory sharedInformerFactory = (SharedInformerFactory)this.beanFactory.getBean(SharedInformerFactory.class);
        GenericKubernetesApi api = new GenericKubernetesApi(kubernetesInformer.apiTypeClass(), kubernetesInformer.apiListTypeClass(), kubernetesInformer.groupVersionResource().apiGroup(), kubernetesInformer.groupVersionResource().apiVersion(), kubernetesInformer.groupVersionResource().resourcePlural(), apiClient);
        SharedIndexInformer sharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(api, type, kubernetesInformer.resyncPeriodMillis(), kubernetesInformer.namespace());
        return sharedIndexInformer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

