/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.azure.resourcemanager.redis.fluent.models.RedisPropertiesInner;
import com.azure.resourcemanager.redis.models.ManagedServiceIdentity;
import com.azure.resourcemanager.redis.models.ProvisioningState;
import com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.azure.resourcemanager.redis.models.RedisInstanceDetails;
import com.azure.resourcemanager.redis.models.RedisLinkedServer;
import com.azure.resourcemanager.redis.models.Sku;
import com.azure.resourcemanager.redis.models.TlsVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RedisResourceInner
extends Resource {
    @JsonProperty(value="properties", required=true)
    private RedisPropertiesInner innerProperties = new RedisPropertiesInner();
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(RedisResourceInner.class);

    private RedisPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public RedisResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public RedisResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public RedisResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RedisResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    public Integer sslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().sslPort();
    }

    public RedisAccessKeysInner accessKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().accessKeys();
    }

    public List<RedisLinkedServer> linkedServers() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedServers();
    }

    public List<RedisInstanceDetails> instances() {
        return this.innerProperties() == null ? null : this.innerProperties().instances();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public RedisResourceInner withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public RedisResourceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public RedisResourceInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public RedisConfiguration redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    public RedisResourceInner withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisConfiguration(redisConfiguration);
        return this;
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public RedisResourceInner withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    public RedisResourceInner withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    public RedisResourceInner withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    public RedisResourceInner withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    public RedisResourceInner withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withTenantSettings((Map)tenantSettings);
        return this;
    }

    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    public RedisResourceInner withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public RedisResourceInner withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RedisResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisPropertiesInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RedisResourceInner"));
        }
        this.innerProperties().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

