/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class UnmodifiableListDeserializer
extends JsonDeserializer<List> {
    UnmodifiableListDeserializer() {
    }

    public List deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        ArrayList<Object> result = new ArrayList<Object>();
        if (node != null) {
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                for (JsonNode elementNode : arrayNode) {
                    result.add(mapper.readValue(elementNode.traverse((ObjectCodec)mapper), Object.class));
                }
            } else {
                result.add(mapper.readValue(node.traverse((ObjectCodec)mapper), Object.class));
            }
        }
        return Collections.unmodifiableList(result);
    }
}

