/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.config.AlertConfig;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.service.AbstractEventSender;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.extract.alert.request.AlertSendResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlertSender
extends AbstractEventSender<Alert> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertSender.class);
    private final AlertDao alertDao;

    public AlertSender(AlertDao alertDao, AlertPluginManager alertPluginManager, AlertConfig alertConfig) {
        super(alertPluginManager, alertConfig.getWaitTimeout());
        this.alertDao = alertDao;
    }

    public AlertSendResponse syncHandler(int alertGroupId, String title, String content) {
        List alertInstanceList = this.alertDao.listInstanceByAlertGroupId(alertGroupId);
        AlertData alertData = AlertData.builder().content(content).title(title).build();
        boolean sendResponseStatus = true;
        ArrayList<AlertSendResponse.AlertSendResponseResult> sendResponseResults = new ArrayList<AlertSendResponse.AlertSendResponseResult>();
        if (CollectionUtils.isEmpty((Collection)alertInstanceList)) {
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult();
            String message = String.format("Alert GroupId %s send error : not found alert instance", alertGroupId);
            alertSendResponseResult.setSuccess(false);
            alertSendResponseResult.setMessage(message);
            sendResponseResults.add(alertSendResponseResult);
            log.error("Alert GroupId {} send error : not found alert instance", (Object)alertGroupId);
            return new AlertSendResponse(false, sendResponseResults);
        }
        for (AlertPluginInstance instance : alertInstanceList) {
            AlertResult alertResult = this.doSendEvent(instance, alertData);
            if (alertResult == null) continue;
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = new AlertSendResponse.AlertSendResponseResult(alertResult.isSuccess(), alertResult.getMessage());
            sendResponseStatus = sendResponseStatus && alertSendResponseResult.isSuccess();
            sendResponseResults.add(alertSendResponseResult);
        }
        return new AlertSendResponse(sendResponseStatus, sendResponseResults);
    }

    @Override
    public List<AlertPluginInstance> getAlertPluginInstanceList(Alert event) {
        return this.alertDao.listInstanceByAlertGroupId(event.getAlertGroupId().intValue());
    }

    @Override
    public AlertData getAlertData(Alert event) {
        return AlertData.builder().id(event.getId().intValue()).content(event.getContent()).log(event.getLog()).title(event.getTitle()).alertType(event.getAlertType().getCode()).build();
    }

    @Override
    public Integer getEventId(Alert event) {
        return event.getId();
    }

    @Override
    public void onError(Alert event, String log) {
        this.alertDao.updateAlert(AlertStatus.EXECUTION_FAILURE, log, event.getId().intValue());
    }

    @Override
    public void onPartialSuccess(Alert event, String log) {
        this.alertDao.updateAlert(AlertStatus.EXECUTION_PARTIAL_SUCCESS, log, event.getId().intValue());
    }

    @Override
    public void onSuccess(Alert event, String log) {
        this.alertDao.updateAlert(AlertStatus.EXECUTION_SUCCESS, log, event.getId().intValue());
    }
}

