/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.plugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourcePluginManager;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.spi.datasource.AdHocDataSourceClient;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannel;
import org.apache.dolphinscheduler.spi.datasource.DataSourceClient;
import org.apache.dolphinscheduler.spi.datasource.PooledDataSourceClient;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceClientProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceClientProvider.class);
    private static final Cache<String, PooledDataSourceClient> POOLED_DATASOURCE_CLIENT_CACHE = CacheBuilder.newBuilder().expireAfterWrite(PropertyUtils.getLong((String)"kerberos.expire.time", (Long)24L).longValue(), TimeUnit.HOURS).removalListener(notification -> {
        try (PooledDataSourceClient closedClient = (PooledDataSourceClient)notification.getValue();){
            log.info("Datasource: {} is removed from cache due to expire", notification.getKey());
        }
        catch (Exception e) {
            log.error("Close datasource client error", (Throwable)e);
        }
    }).maximumSize(100L).build();
    private static final DataSourcePluginManager dataSourcePluginManager = new DataSourcePluginManager();

    public static DataSourceClient getPooledDataSourceClient(DbType dbType, ConnectionParam connectionParam) throws ExecutionException {
        BaseConnectionParam baseConnectionParam = (BaseConnectionParam)connectionParam;
        String datasourceUniqueId = DataSourceUtils.getDatasourceUniqueId((ConnectionParam)baseConnectionParam, dbType);
        return (DataSourceClient)POOLED_DATASOURCE_CLIENT_CACHE.get((Object)datasourceUniqueId, () -> {
            DataSourceChannel dataSourceChannel = dataSourcePluginManager.getDataSourceChannel(dbType);
            if (null == dataSourceChannel) {
                throw new RuntimeException(String.format("datasource plugin '%s' is not found", dbType.getName()));
            }
            return dataSourceChannel.createPooledDataSourceClient(baseConnectionParam, dbType);
        });
    }

    public static Connection getPooledConnection(DbType dbType, ConnectionParam connectionParam) throws SQLException, ExecutionException {
        return DataSourceClientProvider.getPooledDataSourceClient(dbType, connectionParam).getConnection();
    }

    public static AdHocDataSourceClient getAdHocDataSourceClient(DbType dbType, ConnectionParam connectionParam) {
        BaseConnectionParam baseConnectionParam = (BaseConnectionParam)connectionParam;
        DataSourceChannel dataSourceChannel = dataSourcePluginManager.getDataSourceChannel(dbType);
        if (null == dataSourceChannel) {
            throw new RuntimeException(String.format("datasource plugin '%s' is not found", dbType.getName()));
        }
        return dataSourceChannel.createAdHocDataSourceClient(baseConnectionParam, dbType);
    }

    public static Connection getAdHocConnection(DbType dbType, ConnectionParam connectionParam) throws SQLException, ExecutionException {
        return DataSourceClientProvider.getAdHocDataSourceClient(dbType, connectionParam).getConnection();
    }

    static {
        dataSourcePluginManager.installPlugin();
    }
}

